/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security.config;

import cn.bestwu.simpleframework.security.AuthorizationServerHttpSecurityConfigurerAdapter;
import cn.bestwu.simpleframework.security.ClientAuthorize;
import cn.bestwu.simpleframework.security.config.CorsProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.configuration.ClientDetailsServiceConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerSecurityConfiguration;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Order(value=0)
@AutoConfigureOrder(value=-2147483638)
@Configuration
@ConditionalOnWebApplication
@Import(value={ClientDetailsServiceConfiguration.class, AuthorizationServerEndpointsConfiguration.class})
public class AuthorizationServerConfiguration
extends AuthorizationServerSecurityConfiguration {
    private List<AuthorizationServerHttpSecurityConfigurerAdapter> configurers = Collections.emptyList();
    private final CorsProperties corsProperties;
    private final ApplicationContext applicationContext;
    public static final ReflectionUtils.MethodFilter USER_METHODS = method -> !method.isSynthetic() && !method.isBridge() && !ReflectionUtils.isObjectMethod((Method)method) && !ClassUtils.isCglibProxyClass(method.getDeclaringClass()) && !ReflectionUtils.isCglibRenamedMethod((Method)method);

    public AuthorizationServerConfiguration(CorsProperties corsProperties, ApplicationContext applicationContext) {
        this.corsProperties = corsProperties;
        this.applicationContext = applicationContext;
    }

    @Autowired(required=false)
    public void setConfigurers(List<AuthorizationServerHttpSecurityConfigurerAdapter> configurers) {
        this.configurers = configurers;
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        if (this.corsProperties.isEnable()) {
            http.cors();
        }
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(Controller.class);
        beansWithAnnotation.putAll(this.applicationContext.getBeansWithAnnotation(FrameworkEndpoint.class));
        beansWithAnnotation.putAll(this.applicationContext.getBeansWithAnnotation(ClientAuthorize.class));
        LinkedMultiValueMap cachedAntMatchers = new LinkedMultiValueMap();
        for (Object o : beansWithAnnotation.values()) {
            AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);
            ReflectionUtils.doWithMethods(o.getClass(), arg_0 -> AuthorizationServerConfiguration.lambda$configure$0(DISCOVERER, (MultiValueMap)cachedAntMatchers, arg_0), (ReflectionUtils.MethodFilter)USER_METHODS);
        }
        for (HttpMethod method : cachedAntMatchers.keySet()) {
            String[] antPatterns = ((List)cachedAntMatchers.get((Object)method)).toArray(new String[0]);
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().requestMatchers(new RequestMatcher[0])).antMatchers(method, antPatterns)).and().authorizeRequests().antMatchers(method, antPatterns)).fullyAuthenticated();
        }
        for (AuthorizationServerHttpSecurityConfigurerAdapter configurer : this.configurers) {
            configurer.configure(http);
        }
    }

    private static /* synthetic */ void lambda$configure$0(AnnotationMappingDiscoverer DISCOVERER, MultiValueMap cachedAntMatchers, Method method) throws IllegalArgumentException, IllegalAccessException {
        block2: {
            ClientAuthorize clientAuthorize;
            block3: {
                RequestMethod[] methods;
                clientAuthorize = (ClientAuthorize)AnnotationUtils.findAnnotation((Method)method, ClientAuthorize.class);
                if (clientAuthorize == null) break block2;
                RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                if (mapping == null) break block3;
                String url = DISCOVERER.getMapping(method);
                for (RequestMethod requestMethod : methods = mapping.method()) {
                    cachedAntMatchers.add((Object)HttpMethod.valueOf((String)requestMethod.name()), (Object)url);
                }
                break block2;
            }
            if (clientAuthorize.value().length <= 0) break block2;
            for (String url : clientAuthorize.value()) {
                cachedAntMatchers.add((Object)clientAuthorize.method(), (Object)url);
            }
        }
    }
}

