/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.IMenu;
import cn.bestwu.simpleframework.security.ISecurityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class URLFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private final Map<AntPathRequestMatcher, Collection<ConfigAttribute>> allDefaultRequestMap = new HashMap<AntPathRequestMatcher, Collection<ConfigAttribute>>();
    private Map<AntPathRequestMatcher, Collection<ConfigAttribute>> requestMap;
    private final ISecurityService securityService;
    private final String[] ignored;

    public URLFilterInvocationSecurityMetadataSource(ISecurityService securityService, RequestMappingHandlerMapping handlerMapping, String[] ignored) {
        this.securityService = securityService;
        this.ignored = ignored;
        for (RequestMappingInfo mappingInfo : handlerMapping.getHandlerMethods().keySet()) {
            for (String pattern : mappingInfo.getPatternsCondition().getPatterns()) {
                if (this.ignored(pattern)) continue;
                Set methods = mappingInfo.getMethodsCondition().getMethods();
                if (methods.isEmpty()) {
                    this.allDefaultRequestMap.put(new AntPathRequestMatcher(pattern), SecurityConfig.createList((String[])new String[]{"authenticated"}));
                    continue;
                }
                for (RequestMethod requestMethod : methods) {
                    this.allDefaultRequestMap.put(new AntPathRequestMatcher(pattern, requestMethod.name()), SecurityConfig.createList((String[])new String[]{"authenticated"}));
                }
            }
        }
        this.bindRequestMap();
    }

    private boolean ignored(String path) {
        if (this.ignored == null) {
            return false;
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String pattern : this.ignored) {
            if (!antPathMatcher.match(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (Map.Entry<AntPathRequestMatcher, Collection<ConfigAttribute>> entry : this.requestMap.entrySet()) {
            allAttributes.addAll(entry.getValue());
        }
        return allAttributes;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        ArrayList<Match> matches = new ArrayList<Match>();
        Comparator comparator = new AntPathMatcher().getPatternComparator(this.getRequestPath(request));
        for (Map.Entry<AntPathRequestMatcher, Collection<ConfigAttribute>> entry : this.requestMap.entrySet()) {
            if (!entry.getKey().matches(request)) continue;
            matches.add(new Match(comparator, entry.getKey().getPattern(), entry.getValue()));
        }
        if (!matches.isEmpty()) {
            Collections.sort(matches);
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1) {
                Match secondBestMatch = (Match)matches.get(1);
                if (comparator.compare(bestMatch.path, secondBestMatch.path) == 0) {
                    String m1 = bestMatch.path;
                    String m2 = secondBestMatch.path;
                    throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + request.getRequestURL() + "': {" + m1 + ", " + m2 + "}");
                }
            }
            return bestMatch.configAttributes;
        }
        return null;
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + request.getPathInfo();
        }
        return url;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    protected void bindRequestMap() {
        this.requestMap = new LinkedHashMap<AntPathRequestMatcher, Collection<ConfigAttribute>>(this.allDefaultRequestMap);
        List<? extends IMenu> list = this.securityService.findAllMenus();
        for (IMenu iMenu : list) {
            String url = iMenu.getUrl();
            String method = iMenu.getMethod();
            List<String> authorities = iMenu.getAuthorities();
            List atts = SecurityConfig.createList((String[])authorities.toArray(new String[0]));
            for (String s : url.split(",")) {
                for (String m : method.split(",")) {
                    this.requestMap.put(new AntPathRequestMatcher(s, m), atts);
                }
            }
        }
    }

    public void refreshResuorceMap() {
        this.bindRequestMap();
    }

    private class Match
    implements Comparable<Match> {
        private final Comparator<String> comparator;
        private final String path;
        private final Collection<ConfigAttribute> configAttributes;

        private Match(Comparator<String> comparator, String path, Collection<ConfigAttribute> configAttributes) {
            this.comparator = comparator;
            this.path = path;
            this.configAttributes = configAttributes;
        }

        @Override
        public int compareTo(@NotNull Match o) {
            return this.comparator.compare(this.path, o.path);
        }
    }
}

