/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.CustomUserDetails;
import cn.bestwu.simpleframework.security.ISecurityUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public final class AuthenticationHelper {
    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static ISecurityUser getSigninUser() {
        Authentication authentication = AuthenticationHelper.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof CustomUserDetails) {
            return ((CustomUserDetails)principal).getUser();
        }
        return null;
    }

    public static CustomUserDetails getUserAwareUserDetails() {
        Authentication authentication = AuthenticationHelper.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof CustomUserDetails) {
            return (CustomUserDetails)principal;
        }
        return null;
    }

    public static boolean hasAuthority(Authentication authentication, String authority) {
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals(authority)) continue;
            return true;
        }
        return false;
    }
}

