/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security.exception;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultOAuth2ExceptionRenderer;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.error.OAuth2ExceptionRenderer;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

public class AbstractOAuth2SecurityExceptionHandler {
    private WebResponseExceptionTranslator<OAuth2Exception> exceptionTranslator = new DefaultWebResponseExceptionTranslator();
    private OAuth2ExceptionRenderer exceptionRenderer = new DefaultOAuth2ExceptionRenderer();
    private final HandlerExceptionResolver handlerExceptionResolver = new DefaultHandlerExceptionResolver();
    public static MessageSource messageSource;

    public AbstractOAuth2SecurityExceptionHandler(MessageSource messageSource) {
        AbstractOAuth2SecurityExceptionHandler.messageSource = messageSource;
    }

    public static String getText(Object code, Object ... args) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes == null ? null : requestAttributes.getRequest();
        String codeString = String.valueOf(code);
        return messageSource.getMessage(codeString, args, codeString, request == null ? Locale.CHINA : request.getLocale());
    }

    public void setExceptionTranslator(WebResponseExceptionTranslator<OAuth2Exception> exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setExceptionRenderer(OAuth2ExceptionRenderer exceptionRenderer) {
        this.exceptionRenderer = exceptionRenderer;
    }

    protected void doHandle(HttpServletRequest request, HttpServletResponse response, RuntimeException authException) throws IOException, ServletException {
        try {
            ResponseEntity<OAuth2Exception> result = this.exceptionTranslator.translate((Exception)authException);
            result = this.enhanceResponse(result, authException);
            HashMap<String, String> body = new HashMap<String, String>();
            HttpStatus statusCode = result.getStatusCode();
            body.put("status", String.valueOf(statusCode.value()));
            body.put("message", AbstractOAuth2SecurityExceptionHandler.getText(((OAuth2Exception)result.getBody()).getMessage(), new Object[0]));
            this.exceptionRenderer.handleHttpEntityResponse((HttpEntity)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)statusCode).headers(result.getHeaders())).body(body), new ServletWebRequest(request, response));
            response.flushBuffer();
        }
        catch (ServletException e) {
            if (this.handlerExceptionResolver.resolveException(request, response, (Object)this, (Exception)((Object)e)) == null) {
                throw e;
            }
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ResponseEntity<OAuth2Exception> enhanceResponse(ResponseEntity<OAuth2Exception> result, Exception authException) {
        return result;
    }
}

