package cn.bestwu.simpleframework.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * @author Peter Wu
 */
public final class AuthenticationHelper {

  /**
   * @return 授权信息
   */
  public static Authentication getAuthentication() {
    return SecurityContextHolder.getContext().getAuthentication();
  }

  /**
   * @return 登录用户
   */
  public static ISecurityUser getSigninUser() {
    Authentication authentication = getAuthentication();
    if (authentication == null) {
      return null;
    }
    Object principal = authentication.getPrincipal();
    if (principal instanceof CustomUserDetails) {
      return ((CustomUserDetails) principal).getUser();
    }
    return null;
  }

  /**
   * @return UserAwareUserDetails
   */
  public static CustomUserDetails getUserAwareUserDetails() {
    Authentication authentication = getAuthentication();
    if (authentication == null) {
      return null;
    }
    Object principal = authentication.getPrincipal();
    if (principal instanceof CustomUserDetails) {
      return ((CustomUserDetails) principal);
    }
    return null;
  }

  /**
   * @param authentication 授权信息
   * @param authority 权限
   * @return 授权信息是否包含指定权限
   */
  public static boolean hasAuthority(Authentication authentication, String authority) {
    for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
      if (grantedAuthority.getAuthority().equals(authority)) {
        return true;
      }
    }
    return false;
  }

}
