package cn.bestwu.simpleframework.support.excel;

import java.util.List;
import javax.validation.ConstraintViolationException;
import javax.xml.bind.ValidationException;

/**
 * @author Peter Wu
 */
public class ExcelImportException extends ValidationException {

  private static final long serialVersionUID = 1L;

  private List<CellError> errors;

  public ExcelImportException(List<CellError> errors) {
    this(null, errors);
  }

  public ExcelImportException(String message,
      List<CellError> errors) {
    super(message);
    this.errors = errors;
  }

  public List<CellError> getErrors() {
    return errors;
  }

  public static class CellError {

    private Integer row;
    private Integer column;
    private ConstraintViolationException exception;

    /**
     * @param row 行号
     * @param column 列号
     * @param exception 异常
     */
    public CellError(Integer row, Integer column,
        ConstraintViolationException exception) {
      this.row = row;
      this.column = column;
      this.exception = exception;
    }

    public Integer getRow() {
      return row;
    }

    public void setRow(Integer row) {
      this.row = row;
    }

    public Integer getColumn() {
      return column;
    }

    public void setColumn(Integer column) {
      this.column = column;
    }

    public ConstraintViolationException getException() {
      return exception;
    }

    public void setException(ConstraintViolationException exception) {
      this.exception = exception;
    }
  }
}
