/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web;

import cn.bestwu.simpleframework.exception.BusinessException;
import cn.bestwu.simpleframework.exception.ResourceNotFoundException;
import cn.bestwu.simpleframework.support.excel.ExcelImportException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.multipart.MultipartException;

@Order(value=-2147483648)
public class ErrorAttributes
extends DefaultErrorAttributes {
    protected final String KEY_STATUS = "status";
    protected final String KEY_MESSAGE = "message";
    private final Logger log = LoggerFactory.getLogger(ErrorAttributes.class);
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired
    private MessageSource messageSource;

    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        String message;
        String statusCode = null;
        Integer httpStatusCode = null;
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        Throwable e = this.getError(requestAttributes);
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        if (e != null) {
            BindException er;
            message = e.getMessage();
            if (includeStackTrace) {
                this.addStackTrace(errorAttributes, e);
            }
            if (e instanceof ResourceNotFoundException || e instanceof EmptyResultDataAccessException) {
                httpStatusCode = HttpStatus.NOT_FOUND.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "resource.not.found";
                }
            } else if (e instanceof HttpRequestMethodNotSupportedException) {
                httpStatusCode = HttpStatus.METHOD_NOT_ALLOWED.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "method.not.allowed";
                }
            } else if (e instanceof BindException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                er = (BindException)e;
                List fieldErrors = er.getFieldErrors();
                for (FieldError fieldError : fieldErrors) {
                    String defaultMessage = fieldError.getDefaultMessage();
                    if (defaultMessage.contains("required type")) {
                        defaultMessage = this.getText(fieldError.getCode(), new Object[0]);
                    }
                    errors.put(fieldError.getField(), this.getText(fieldError.getField(), new Object[0]) + defaultMessage);
                }
                message = (String)errors.values().iterator().next();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (e instanceof IllegalArgumentException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (e instanceof MissingServletRequestParameterException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
            } else if (e instanceof ConversionFailedException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = this.getText("typeMismatch", ((ConversionFailedException)e).getValue(), ((ConversionFailedException)e).getTargetType());
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (e instanceof ConstraintViolationException || e instanceof TransactionSystemException) {
                if (e instanceof TransactionSystemException) {
                    e = ((TransactionSystemException)e).getRootCause();
                }
                if (e instanceof ConstraintViolationException) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    er = (ConstraintViolationException)e;
                    Set constraintViolations = er.getConstraintViolations();
                    for (ConstraintViolation constraintViolation : constraintViolations) {
                        errors.put(constraintViolation.getPropertyPath().toString(), this.getText(constraintViolation.getPropertyPath(), new Object[0]) + constraintViolation.getMessage());
                    }
                    message = (String)errors.values().iterator().next();
                    if (!StringUtils.hasText((String)message)) {
                        message = "data.valid.failed";
                    }
                }
            } else if (e instanceof DataIntegrityViolationException) {
                String specificCauseMessage = ((DataIntegrityViolationException)e).getMostSpecificCause().getMessage();
                String duplicateRegex = "^Duplicate entry '(.*?)'.*";
                String constraintSubfix = "Cannot delete or update a parent row";
                if (specificCauseMessage.matches(duplicateRegex)) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    message = this.getText("duplicate.entry", specificCauseMessage.replaceAll(duplicateRegex, "$1"));
                    if (!StringUtils.hasText((String)message)) {
                        message = "data.valid.failed";
                    }
                } else if (specificCauseMessage.startsWith(constraintSubfix)) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    message = "cannot.delete.update.parent";
                    if (!StringUtils.hasText((String)message)) {
                        message = "data.valid.failed";
                    }
                } else {
                    message = ((DataIntegrityViolationException)e).getRootCause().getMessage();
                }
            } else if (e instanceof HttpMediaTypeNotAcceptableException) {
                httpStatusCode = HttpStatus.NOT_ACCEPTABLE.value();
                message = "MediaType not Acceptable!Must ACCEPT:" + ((HttpMediaTypeNotAcceptableException)e).getSupportedMediaTypes();
            } else if (e instanceof IllegalStateException) {
                httpStatusCode = HttpStatus.CONFLICT.value();
            } else if (e instanceof MultipartException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = "upload.fail";
            } else if (e instanceof HttpMessageNotWritableException) {
                if (message.contains("Session is closed")) {
                    httpStatusCode = HttpStatus.REQUEST_TIMEOUT.value();
                    message = "request.timeout";
                }
            } else if (e instanceof ExcelImportException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                List<ExcelImportException.CellError> cellErrors = ((ExcelImportException)((Object)e)).getErrors();
                for (ExcelImportException.CellError cellError : cellErrors) {
                    String key = "\u7b2c" + cellError.getRow() + "\u884c\u7b2c" + (char)(65 + cellError.getColumn()) + "\u5217";
                    ConstraintViolationException value = cellError.getException();
                    for (ConstraintViolation constraintViolation : value.getConstraintViolations()) {
                        errors.put(key, this.getText(constraintViolation.getPropertyPath(), new Object[0]) + constraintViolation.getMessage());
                    }
                }
                Map.Entry firstError = errors.entrySet().iterator().next();
                message = (String)firstError.getKey() + ": " + (String)firstError.getValue();
            } else if (e instanceof BusinessException) {
                statusCode = ((BusinessException)e).getCode();
            }
        } else {
            message = (String)this.getAttribute(requestAttributes, "javax.servlet.error.message");
        }
        if (httpStatusCode == null) {
            ResponseStatus responseStatus;
            if (e != null && (responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(e.getClass(), ResponseStatus.class)) != null) {
                httpStatusCode = responseStatus.code().value();
                String reason = responseStatus.reason();
                if (StringUtils.hasText((String)reason)) {
                    message = reason;
                }
            }
            if (httpStatusCode == null && (httpStatusCode = Integer.valueOf(this.getStatus(requestAttributes).value())) != 406 && httpStatusCode != 401 && httpStatusCode != 403 && httpStatusCode != 404 && httpStatusCode != 405) {
                if (e != null) {
                    this.log.error(httpStatusCode + ":" + message, e);
                } else {
                    this.log.warn(httpStatusCode + ":" + message);
                }
            }
        }
        this.setStatus(requestAttributes, httpStatusCode);
        statusCode = statusCode == null ? String.valueOf(httpStatusCode) : statusCode;
        message = StringUtils.hasText((String)message) ? message : "No message available";
        message = this.getText(message, new Object[0]);
        errorAttributes.put("status", statusCode);
        errorAttributes.put("message", message);
        if (!errors.isEmpty()) {
            errorAttributes.put("errors", errors);
        }
        return errorAttributes;
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable error) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    private void setStatus(RequestAttributes requestAttributes, Object statusCode) {
        requestAttributes.setAttribute("javax.servlet.error.status_code", statusCode, 0);
    }

    private HttpStatus getStatus(RequestAttributes requestAttributes) {
        Integer statusCode = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }

    private String getText(Object code, Object ... args) {
        String codeString = String.valueOf(code);
        return this.messageSource.getMessage(codeString, args, codeString, this.request == null ? Locale.CHINA : this.request.getLocale());
    }
}

