/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web;

import cn.bestwu.lang.util.ParameterUtil;
import cn.bestwu.lang.util.Sha1DigestUtil;
import cn.bestwu.simpleframework.data.PaginationList;
import cn.bestwu.simpleframework.support.DeviceUtil;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StringUtils;

@ConditionalOnWebApplication
public class BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired
    private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private MessageSource messageSource;

    public static HttpHeaders cacheControl(HttpHeaders headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setCacheControl("no-cache, must-revalidate");
        headers.setPragma("no-cache");
        headers.setExpires(-1L);
        return headers;
    }

    protected ResponseEntity created(Object resource) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(resource);
    }

    protected ResponseEntity updated(Object resource) {
        return this.ok(resource);
    }

    protected ResponseEntity ok(Object object) {
        return ResponseEntity.ok((Object)object);
    }

    protected <T> ResponseEntity page(List<T> list) {
        Page page = new Page();
        page.setRecords(list);
        if (list instanceof PaginationList) {
            Pagination pagination = ((PaginationList)list).getPagination();
            page.setCurrent(pagination.getCurrent());
            page.setSize(pagination.getSize());
            page.setTotal(pagination.getTotal());
        } else if (list instanceof Collection) {
            page.setCurrent(1);
            page.setSize(list.size());
            page.setTotal(list.size());
        }
        return ResponseEntity.ok((Object)page);
    }

    protected ResponseEntity cacheable(Object object) {
        return this.cacheable(object, null);
    }

    protected ResponseEntity cacheable(Object object, Class<?> serializationView) {
        try {
            ObjectMapper objectMapper = this.mappingJackson2HttpMessageConverter.getObjectMapper();
            ObjectWriter objectWriter = serializationView != null ? objectMapper.writerWithView(serializationView) : objectMapper.writer();
            String body = objectWriter.writeValueAsString(object);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
            httpHeaders.setETag("\"".concat(Sha1DigestUtil.shaHex((String)body)).concat("\""));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(BaseController.cacheControl(httpHeaders))).body((Object)body);
        }
        catch (JsonProcessingException e) {
            return ResponseEntity.ok((Object)object);
        }
    }

    protected ResponseEntity noContent() {
        return ResponseEntity.noContent().build();
    }

    public String getText(Object code, Object ... args) {
        String codeString = String.valueOf(code);
        return this.messageSource.getMessage(codeString, args, codeString, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getTextDefaultNull(Object code, Object ... args) {
        return this.messageSource.getMessage(String.valueOf(code), args, null, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getUserAgent() {
        return DeviceUtil.getUserAgent(this.request);
    }

    protected String getDeviceInfo() {
        return DeviceUtil.getDeviceInfo(this.request);
    }

    protected Object getOldModel() {
        String oldModel = "OLD_MODEL";
        return this.request.getAttribute(oldModel);
    }

    protected boolean hasParameter(String key) {
        return ParameterUtil.hasParameter((Map)this.request.getParameterMap(), (String)key);
    }

    protected boolean hasParameterKey(String key) {
        return ParameterUtil.hasParameterKey((Map)this.request.getParameterMap(), (String)key);
    }

    protected void hasText(String param, String paramName) {
        if (!StringUtils.hasText((String)param)) {
            throw new IllegalArgumentException(this.getText("param.notnull", paramName));
        }
    }

    protected void notNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException(this.getText("param.notnull", paramName));
        }
    }
}

