/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.packagescan;

import cn.bestwu.simpleframework.support.packagescan.AssignableToPackageScanFilter;
import cn.bestwu.simpleframework.support.packagescan.CompositePackageScanFilter;
import cn.bestwu.simpleframework.support.packagescan.PackageScanFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tomcat.util.buf.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.jar.JarFile;

public class PackageScanClassResolver {
    private Logger log = LoggerFactory.getLogger(PackageScanClassResolver.class);
    private Set<ClassLoader> classLoaders;
    private Set<PackageScanFilter> scanFilters;
    private Map<String, Set<Class>> allClassesByPackage = new HashMap<String, Set<Class>>();
    private Set<String> loadedPackages = new HashSet<String>();
    private Map<String, Set<String>> classFilesByLocation = new HashMap<String, Set<String>>();
    private static final String SPRING_BOOT_PREFIX = "BOOT-INF/classes/";

    public void addClassLoader(ClassLoader classLoader) {
        try {
            this.getClassLoaders().add(classLoader);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.log.debug("The thread context class loader: " + ccl + "  is used to load the class");
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(PackageScanClassResolver.class.getClassLoader());
        }
        return this.classLoaders;
    }

    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        this.log.debug("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames));
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        if (!this.loadedPackages.contains(packageName)) {
            for (ClassLoader classLoader : set) {
                this.findAllClasses(packageName, classLoader);
            }
            this.loadedPackages.add(packageName);
        }
        this.findInAllClasses(test, packageName, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findAllClasses(String packageName, ClassLoader loader) {
        Enumeration<URL> urls;
        this.log.debug("Searching for all classes in package: " + packageName + " using classloader: " + loader.getClass().getName());
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.debug("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot read package: " + packageName, (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                File file;
                url = urls.nextElement();
                this.log.debug("URL from classloader: " + url);
                url = this.customResourceLocator(url);
                String urlPath = url.getFile();
                String host = null;
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (url.getProtocol().equals("vfs") && !urlPath.startsWith("vfs")) {
                    urlPath = "vfs:" + urlPath;
                }
                if (url.getProtocol().equals("vfszip") && !urlPath.startsWith("vfszip")) {
                    urlPath = "vfszip:" + urlPath;
                }
                this.log.debug("Decoded urlPath: " + urlPath + " with protocol: " + url.getProtocol());
                if (urlPath.startsWith("file:")) {
                    try {
                        URI uri = new URI(url.getFile());
                        host = uri.getHost();
                        urlPath = uri.getPath();
                    }
                    catch (URISyntaxException uri) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.debug("It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.contains(".jar/") && !urlPath.contains(".jar!/")) {
                    urlPath = urlPath.replace(".jar/", ".jar!/");
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (host != null) {
                    urlPath = urlPath.startsWith("/") ? "//" + host + urlPath : "//" + host + "/" + urlPath;
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    this.log.debug("Loading from directory using file: " + file);
                    this.loadImplementationsInDirectory(packageName, file, loader);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || urlPath.startsWith("vfs:") || urlPath.startsWith("vfszip:")) {
                    URL urlStream = new URL(urlPath);
                    this.log.debug("Loading from jar using " + urlStream.getProtocol() + ": " + urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    this.log.debug("Loading from jar using file: " + file);
                    stream = new FileInputStream(file);
                }
                try {
                    this.loadImplementationsInJar(packageName, stream, loader, urlPath, null);
                }
                catch (IOException ioe) {
                    this.log.warn("Cannot search jar file '" + urlPath + "' for classes due to an IOException: " + ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.log.debug("Cannot read entries in url: " + url, (Throwable)e);
            }
        }
    }

    protected void findInAllClasses(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        this.log.debug("Searching for: " + test + " in package: " + packageName);
        Set<Class> packageClasses = this.getFoundClasses(packageName);
        if (packageClasses == null) {
            this.log.debug("No classes found in package: " + packageName);
            return;
        }
        for (Class type : packageClasses) {
            if (!test.matches(type)) continue;
            classes.add(type);
        }
    }

    protected void addFoundClass(Class<?> type) {
        if (type.getPackage() != null) {
            String packageName = type.getPackage().getName();
            List<String> packageNameParts = Arrays.asList(packageName.split("\\."));
            for (int i = 0; i < packageNameParts.size(); ++i) {
                String thisPackage = StringUtils.join(packageNameParts.subList(0, i + 1), (char)'/');
                this.addFoundClass(thisPackage, type);
            }
        }
    }

    protected void addFoundClass(String packageName, Class<?> type) {
        if (!this.allClassesByPackage.containsKey(packageName = packageName.replace("/", "."))) {
            this.allClassesByPackage.put(packageName, new HashSet());
        }
        this.allClassesByPackage.get(packageName).add(type);
    }

    protected Set<Class> getFoundClasses(String packageName) {
        packageName = packageName.replace("/", ".");
        return this.allClassesByPackage.get(packageName);
    }

    protected URL customResourceLocator(URL url) {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.log.debug("Getting resource URL for package: " + packageName + " with classloader: " + loader);
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(String parent, File location, ClassLoader classLoader) {
        Set<String> classFiles = this.classFilesByLocation.get(location.toString());
        if (classFiles == null) {
            File[] files;
            classFiles = new HashSet<String>();
            for (File file : files = location.listFiles()) {
                String packageOrClass;
                StringBuilder builder = new StringBuilder(100);
                String name = file.getName();
                if (name == null) continue;
                name = name.trim();
                builder.append(parent).append("/").append(name);
                String string = packageOrClass = parent == null ? name : builder.toString();
                if (file.isDirectory()) {
                    this.loadImplementationsInDirectory(packageOrClass, file, classLoader);
                    continue;
                }
                if (!name.endsWith(".class")) continue;
                classFiles.add(packageOrClass);
            }
        }
        for (String packageOrClass : classFiles) {
            this.loadClass(packageOrClass, classLoader);
        }
    }

    private void loadClass(String className, ClassLoader classLoader) {
        try {
            if (className.startsWith(SPRING_BOOT_PREFIX)) {
                className = className.substring(SPRING_BOOT_PREFIX.length());
            }
            String externalName = className.substring(0, className.indexOf(46)).replace('/', '.');
            Class<?> type = classLoader.loadClass(externalName);
            this.log.debug("Loaded the class: " + type + " in classloader: " + classLoader);
            this.addFoundClass(type);
        }
        catch (ClassNotFoundException e) {
            this.log.debug("Cannot find class '" + className + "' in classloader: " + classLoader + ". Reason: " + e, (Throwable)e);
        }
        catch (LinkageError e) {
            this.log.debug("Cannot find the class definition '" + className + "' in classloader: " + classLoader + ". Reason: " + e, (Throwable)e);
        }
        catch (Throwable e) {
            this.log.error("Cannot load class '" + className + "' in classloader: " + classLoader + ".  Reason: " + e, e);
        }
    }

    protected void loadImplementationsInJar(String parentPackage, InputStream parentFileStream, ClassLoader loader, String parentFileName, String grandparentFileName) throws IOException {
        Set<String> classFiles = this.classFilesByLocation.get(parentFileName);
        if (classFiles == null) {
            classFiles = new HashSet<String>();
            this.classFilesByLocation.put(parentFileName, classFiles);
            Set<String> grandparentClassFiles = this.classFilesByLocation.get(grandparentFileName);
            if (grandparentClassFiles == null) {
                grandparentClassFiles = new HashSet<String>();
                this.classFilesByLocation.put(grandparentFileName, grandparentClassFiles);
            }
            JarInputStream jarStream = parentFileStream instanceof JarInputStream ? (JarInputStream)parentFileStream : new JarInputStream(parentFileStream);
            File file = new File(parentFileName);
            if (file.exists()) {
                Enumeration entries = new JarFile(file).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = (JarEntry)entries.nextElement();
                    this.loadImplementationsInJar(parentPackage, loader, parentFileName, classFiles, grandparentClassFiles, entry);
                }
            } else {
                JarEntry entry;
                while ((entry = jarStream.getNextJarEntry()) != null) {
                    this.loadImplementationsInJar(parentPackage, loader, parentFileName, classFiles, grandparentClassFiles, entry);
                }
            }
        }
        for (String name : classFiles) {
            if (!name.contains(parentPackage)) continue;
            this.loadClass(name, loader);
        }
    }

    private void loadImplementationsInJar(String parentPackage, ClassLoader loader, String parentFileName, Set<String> classFiles, Set<String> grandparentClassFiles, JarEntry entry) throws IOException {
        String name = entry.getName();
        if (name != null) {
            if (name.endsWith(".jar")) {
                this.log.debug("Found nested jar " + name);
                InputStream nestedJarResourceStream = loader.getResourceAsStream(name);
                if (nestedJarResourceStream != null) {
                    try (JarInputStream nestedJarStream = new JarInputStream(nestedJarResourceStream);){
                        this.loadImplementationsInJar(parentPackage, nestedJarStream, loader, parentFileName + "!" + name, parentFileName);
                    }
                }
            } else if (!entry.isDirectory() && name.endsWith(".class")) {
                classFiles.add(name.trim());
                grandparentClassFiles.add(name.trim());
            }
        }
    }
}

