/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data.resolver;

import com.baomidou.mybatisplus.plugins.Page;
import java.awt.print.Pageable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PagHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String DEFAULT_PAGE_PARAMETER = "page";
    private static final String DEFAULT_SIZE_PARAMETER = "size";
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "_";
    private static final int DEFAULT_MAX_PAGE_SIZE = 2000;
    private static final Page DEFAULT_PAGE_REQUEST = new Page(1, 20);
    private Page fallbackPageable = DEFAULT_PAGE_REQUEST;
    private String pageParameterName = "page";
    private String sizeParameterName = "size";
    private String prefix = "";
    private String qualifierDelimiter = "_";
    private int maxPageSize = 2000;
    private boolean oneIndexedParameters = false;

    public void setFallbackPageable(Page fallbackPageable) {
        this.fallbackPageable = fallbackPageable;
    }

    public boolean isFallbackPageable(Pageable pageable) {
        return this.fallbackPageable.equals(pageable);
    }

    protected int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    protected String getPageParameterName() {
        return this.pageParameterName;
    }

    public void setPageParameterName(String pageParameterName) {
        Assert.hasText((String)pageParameterName, (String)"Page parameter name must not be null or empty!");
        this.pageParameterName = pageParameterName;
    }

    protected String getSizeParameterName() {
        return this.sizeParameterName;
    }

    public void setSizeParameterName(String sizeParameterName) {
        Assert.hasText((String)sizeParameterName, (String)"Size parameter name must not be null or empty!");
        this.sizeParameterName = sizeParameterName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? DEFAULT_PREFIX : prefix;
    }

    public void setQualifierDelimiter(String qualifierDelimiter) {
        this.qualifierDelimiter = qualifierDelimiter == null ? DEFAULT_QUALIFIER_DELIMITER : qualifierDelimiter;
    }

    protected boolean isOneIndexedParameters() {
        return this.oneIndexedParameters;
    }

    public void setOneIndexedParameters(boolean oneIndexedParameters) {
        this.oneIndexedParameters = oneIndexedParameters;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(Page.class);
    }

    public Page resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Page defaultOrFallback = this.getDefaultFromAnnotationOrFallback(methodParameter);
        String pageString = webRequest.getParameter(this.getParameterNameToUse(this.pageParameterName, methodParameter));
        String pageSizeString = webRequest.getParameter(this.getParameterNameToUse(this.sizeParameterName, methodParameter));
        int page = this.parseAndApplyBoundaries(pageString, Integer.MAX_VALUE, true);
        int pageSize = StringUtils.hasText((String)pageSizeString) ? this.parseAndApplyBoundaries(pageSizeString, this.maxPageSize, false) : defaultOrFallback.getSize();
        return new Page(page, pageSize);
    }

    protected String getParameterNameToUse(String source, MethodParameter parameter) {
        StringBuilder builder = new StringBuilder(this.prefix);
        if (parameter != null && parameter.hasParameterAnnotation(Qualifier.class)) {
            builder.append(((Qualifier)parameter.getParameterAnnotation(Qualifier.class)).value());
            builder.append(this.qualifierDelimiter);
        }
        return builder.append(source).toString();
    }

    private Page getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        return this.fallbackPageable;
    }

    private int parseAndApplyBoundaries(String parameter, int upper, boolean shiftIndex) {
        try {
            int parsed = Integer.parseInt(parameter) - (this.oneIndexedParameters && shiftIndex ? 1 : 0);
            return parsed < 1 ? 1 : (parsed > upper ? upper : parsed);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }
}

