package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import java.io.IOException;
import org.springframework.util.StringUtils;

/**
 * JSON序列化url自动补全
 *
 * @author Peter Wu
 */
@JacksonStdImpl
public class UrlStringSerializer extends NonTypedScalarSerializerBase<Object> {

  private static final long serialVersionUID = 1L;

  public static String host;

  public UrlStringSerializer() {
    super(String.class, false);
  }

  private static String convert(String path) {
    if (StringUtils.hasText(path)) {
      return host + path + "?reqid=10000";
    }
    return null;
  }

  @Override
  public boolean isEmpty(SerializerProvider prov, Object value) {
    String str = (String) value;
    return (str == null) || (str.length() == 0);
  }

  @Override
  public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    gen.writeString(convert((String) value));
  }
}
