package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import java.io.IOException;
import org.springframework.util.StringUtils;

/**
 * JSON序列化url自动补全
 *
 * @author Peter Wu
 */
public class UrlArraySerializer extends StringArraySerializer {

  private static final long serialVersionUID = 1L;

  public static String host;


  private static String convert(String value) {
    if (StringUtils.hasText(value)) {
      return host + value + "?reqid=10000";
    }
    return null;
  }

  @Override
  public void serializeContents(String[] value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    final int len = value.length;
    if (len == 0) {
      return;
    }
    for (String str : value) {
      if (str == null) {
        gen.writeNull();
      } else {
        gen.writeString(convert(str));
      }
    }
  }
}
