package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import java.io.IOException;
import org.springframework.util.StringUtils;

/**
 * JSON 序列化电话号码自动隐藏
 *
 * @author Peter Wu
 */
@JacksonStdImpl
public class HideTelSerializer extends NonTypedScalarSerializerBase<Object> {

  private static final long serialVersionUID = 1L;


  public HideTelSerializer() {
    super(String.class, false);
  }

  public static String convert(String value) {
    if (StringUtils.hasText(value)) {
      if (value != null && value.length() == 11) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; i++) {
          if (i > 2 && i < 7) {
            chars[i] = '*';
          }
        }
        return new String(chars);
      }
    }
    return value;
  }

  @Override
  public boolean isEmpty(SerializerProvider prov, Object value) {
    String str = (String) value;
    return (str == null) || (str.length() == 0);
  }

  @Override
  public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    gen.writeString(convert((String) value));
  }
}
