package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.math.BigDecimal;

@JacksonStdImpl
public class BigDecimalSerializer extends StdScalarSerializer<Object> {

  private static final long serialVersionUID = 1759139980737771L;

  public BigDecimalSerializer() {
    super(BigDecimal.class, false);
  }

  @Override
  public void serialize(Object value, JsonGenerator gen,
      SerializerProvider provider) throws IOException {
    BigDecimal bigDecimal = (BigDecimal) value;
    if (bigDecimal.scale() < 2) {
      bigDecimal = bigDecimal.setScale(2, BigDecimal.ROUND_HALF_UP);
    }
    gen.writeNumber(bigDecimal);
  }
}