package cn.bestwu.simpleframework.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author Peter Wu
 */
@ResponseStatus(HttpStatus.BAD_REQUEST)
public class BusinessException extends RuntimeException {

  private static final long serialVersionUID = -7941819415782111951L;
  /**
   * 业务错误码
   */
  private String code;

  public BusinessException(String code) {
    this.code = code;
  }

  public BusinessException(String message, String code) {
    super(message);
    this.code = code;
  }

  public String getCode() {
    return code;
  }
}
