package cn.bestwu.simpleframework.data;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * @author Peter Wu
 */
public class BaseServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<M, T> implements
    IBaseService<T> {

  @Autowired
  private Repositories repositories;
  private Map<String, String> cachedFieldsMap;

  @PostConstruct
  public void init() {
    this.cachedFieldsMap = repositories.getRepositoryMetadataFor(currentModelClass())
        .getCachedFieldsMap();
  }

  @Override
  public boolean deleteByPropertyMap(Map<String, Object> propertyMap) {
    return super.deleteByMap(convert2ColumnMap(propertyMap));
  }

  @Override
  @NotNull
  public Map<String, Object> convert2ColumnMap(Map<String, Object> propertyMap) {
    Map<String, Object> columnMap = new HashMap<>();
    for (Entry<String, Object> entry : propertyMap.entrySet()) {
      columnMap.put(cachedFieldsMap.get(entry.getKey()), entry.getValue());
    }
    return columnMap;
  }

  @Override
  public List<T> selectByPropertyMap(Map<String, Object> propertyMap) {
    return super.selectByMap(convert2ColumnMap(propertyMap));
  }

  protected String like(String keyword) {
    return StringUtils.hasText(keyword) ? ("%" + keyword + "%") : null;
  }
}
