package cn.bestwu.simpleframework.config;

import cn.bestwu.simpleframework.data.Repositories;
import java.util.List;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Peter Wu
 */
@Configuration
public class MybatisConfiguration {

  private final List<MapperFactoryBean> mapperFactoryBeans;

  public MybatisConfiguration(
      @Autowired(required = false) List<MapperFactoryBean> mapperFactoryBeans) {
    this.mapperFactoryBeans = mapperFactoryBeans;
  }

  @Bean
  public Repositories repositories() {
    return new Repositories(mapperFactoryBeans);
  }

}
