/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.resolver;

import cn.bestwu.simpleframework.data.Repositories;
import cn.bestwu.simpleframework.data.RepositoryMetadata;
import cn.bestwu.simpleframework.data.binding.ConditionWrapper;
import cn.bestwu.simpleframework.data.binding.WrapperBinderProperties;
import cn.bestwu.simpleframework.data.dsl.EntityPathWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ConditionWrapperArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final WrapperBinderProperties properties;

    public ConditionWrapperArgumentResolver(Repositories repositories, WrapperBinderProperties properties) {
        this.repositories = repositories;
        this.properties = properties;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(ConditionWrapper.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class modelClass = (Class)((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments()[0];
        return this.resolveWrapper(webRequest, modelClass);
    }

    private Object resolveWrapper(NativeWebRequest request, Class modelClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        String orderBy = request.getParameter(this.properties.getOrderByParameter());
        String isAsc = request.getParameter(this.properties.getIsAscParameter());
        if (!StringUtils.hasText((String)isAsc)) {
            isAsc = this.properties.getDefaultIsAsc();
        }
        String groupBy = request.getParameter(this.properties.getGroupByParameter());
        String isNull = request.getParameter(this.properties.getIsNullParameter());
        String isNotNull = request.getParameter(this.properties.getIsNotNullParameter());
        RepositoryMetadata repositoryMetadataFor = this.repositories.getRepositoryMetadataFor(modelClass);
        EntityPathWrapper<?, ?> wrapper = repositoryMetadataFor.getWrapper();
        Map<String, String> cachedFieldsMap = repositoryMetadataFor.getCachedFieldsMap();
        if (StringUtils.hasText((String)orderBy)) {
            for (String s : orderBy.split(",")) {
                String column;
                String property;
                if (!StringUtils.hasText((String)s) || !StringUtils.hasText((String)(property = s.split(" ")[0])) || (column = cachedFieldsMap.get(property.trim())) == null) continue;
                orderBy = orderBy.replace(property, column);
            }
        }
        groupBy = this.convertProperty2Column(groupBy, cachedFieldsMap);
        isNull = this.convertProperty2Column(isNull, cachedFieldsMap);
        isNotNull = this.convertProperty2Column(isNotNull, cachedFieldsMap);
        if (StringUtils.hasText((String)orderBy)) {
            wrapper.orderBy(orderBy, isAsc.equalsIgnoreCase("asc"));
            wrapper.setSetOrderBy(true);
        }
        if (StringUtils.hasText((String)groupBy)) {
            wrapper.groupBy(groupBy);
            wrapper.setSetGroupBy(true);
        }
        if (StringUtils.hasText((String)isNull)) {
            wrapper.isNull(isNull);
            wrapper.setSetIsNull(true);
        }
        if (StringUtils.hasText((String)isNotNull)) {
            wrapper.isNotNull(isNotNull);
            wrapper.setSetIsNotNull(true);
        }
        HashSet keySet = new HashSet(request.getParameterMap().keySet());
        keySet.remove(this.properties.getOrderByParameter());
        keySet.remove(this.properties.getGroupByParameter());
        keySet.remove(this.properties.getIsAscParameter());
        keySet.remove(this.properties.getIsNullParameter());
        keySet.remove(this.properties.getIsNotNullParameter());
        for (String property : keySet) {
            String value;
            String column = cachedFieldsMap.get(property);
            if (column != null) {
                value = request.getParameter(property);
                if (!StringUtils.hasText((String)value)) continue;
                wrapper.addConditions(column, value);
                continue;
            }
            value = request.getParameter(property);
            if (!StringUtils.hasText((String)value)) continue;
            wrapper.addAdditions(property, value);
        }
        if (repositoryMetadataFor.getWrapperBinderMethod() != null) {
            repositoryMetadataFor.invokeCustomize(wrapper);
        }
        wrapper.doDefault();
        return wrapper;
    }

    private String convertProperty2Column(String properties, Map<String, String> cachedFieldsMap) {
        if (StringUtils.hasText((String)properties)) {
            for (String s : properties.split(",")) {
                String column;
                if (!StringUtils.hasText((String)s) || (column = cachedFieldsMap.get(s.trim())) == null) continue;
                properties = properties.replace(s, column);
            }
        }
        return properties;
    }
}

