/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel;

import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelImportException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImport {
    private static Logger log = LoggerFactory.getLogger(ExcelImport.class);
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private Sheet sheet;
    private Class<?>[] validateGroups = new Class[]{Default.class};
    private int headerNum;

    public ExcelImport(String fileName, int headerNum) throws IOException {
        this(new File(fileName), headerNum);
    }

    public ExcelImport(File file, int headerNum) throws IOException {
        this(file, headerNum, 0);
    }

    public ExcelImport(String fileName, int headerNum, int sheetIndex) throws IOException {
        this(new File(fileName), headerNum, sheetIndex);
    }

    public ExcelImport(File file, int headerNum, int sheetIndex) throws IOException {
        this(file.getName(), new FileInputStream(file), headerNum, sheetIndex);
    }

    public ExcelImport(MultipartFile multipartFile, int headerNum, int sheetIndex) throws IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream(), headerNum, sheetIndex);
    }

    public ExcelImport(String fileName, InputStream is, int headerNum, int sheetIndex) throws IOException {
        HSSFWorkbook wb;
        if (!StringUtils.hasText((String)fileName)) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            wb = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        if (wb.getNumberOfSheets() < sheetIndex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868!");
        }
        this.sheet = wb.getSheetAt(sheetIndex);
        this.headerNum = headerNum;
        log.debug("Initialize success.");
    }

    public Row getRow(int rownum) {
        return this.sheet.getRow(rownum);
    }

    public int getDataRowNum() {
        return this.headerNum + 1;
    }

    public int getLastDataRowNum() {
        return this.sheet.getLastRowNum() + this.headerNum + 1;
    }

    public int getLastCellNum() {
        return this.getRow(this.headerNum).getLastCellNum();
    }

    public Object getCellValue(Row row, int column) {
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (cell != null) {
                if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                    val = cell.getNumericCellValue();
                } else if (cell.getCellTypeEnum() == CellType.STRING) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellTypeEnum() == CellType.FORMULA) {
                    val = cell.getCellFormula();
                } else if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellTypeEnum() == CellType.ERROR) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            log.warn(row + "\uff0c" + column + "\uff0c\u8bfb\u53d6\u6570\u636e\u9519\u8bef", (Throwable)e);
            return val;
        }
        return val;
    }

    public <E> List<E> getDataList(Class<E> cls, int ... groups) throws InstantiationException, IllegalAccessException, NoSuchMethodException, ExcelImportException {
        Method[] ms;
        Field[] fs;
        ArrayList<Object[]> annotationList = new ArrayList<Object[]>();
        block2: for (Field f : fs = cls.getDeclaredFields()) {
            ExcelField ef = f.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != 2) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block3: for (int g : groups) {
                    if (inGroup) continue block2;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        annotationList.add(new Object[]{ef, f});
                        continue block3;
                    }
                }
                continue;
            }
            annotationList.add(new Object[]{ef, f});
        }
        block5: for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelField ef = m.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != 2) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block6: for (int g : groups) {
                    if (inGroup) continue block5;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        annotationList.add(new Object[]{ef, m});
                        continue block6;
                    }
                }
                continue;
            }
            annotationList.add(new Object[]{ef, m});
        }
        annotationList.sort(Comparator.comparingInt(o -> ((ExcelField)o[0]).sort()));
        ArrayList<ExcelImportException.CellError> errors = new ArrayList<ExcelImportException.CellError>();
        ArrayList<E> dataList = new ArrayList<E>();
        for (int i = this.getDataRowNum(); i < this.getLastDataRowNum(); ++i) {
            E e = cls.newInstance();
            int column = 0;
            Row row = this.getRow(i);
            StringBuilder sb = new StringBuilder();
            for (Object[] os : annotationList) {
                Object val;
                if ((val = this.getCellValue(row, column++)) != null) {
                    ExcelField ef = (ExcelField)os[0];
                    Class valType = Class.class;
                    if (os[1] instanceof Field) {
                        valType = ((Field)os[1]).getType();
                    } else if (os[1] instanceof Method) {
                        Method method = (Method)os[1];
                        if ("get".equals(method.getName().substring(0, 3))) {
                            valType = method.getReturnType();
                        } else if ("set".equals(method.getName().substring(0, 3))) {
                            valType = ((Method)os[1]).getParameterTypes()[0];
                        }
                    }
                    try {
                        String s;
                        val = valType == String.class ? (StringUtils.endsWithIgnoreCase((String)(s = String.valueOf(val.toString())), (String)".0") ? s.substring(0, s.lastIndexOf(".0")) : (StringUtils.endsWithIgnoreCase((String)s, (String)"E10") ? s.substring(0, s.lastIndexOf("E10")).replace(".", "") : String.valueOf(val.toString()))) : (valType == Integer.class ? Integer.valueOf(Double.valueOf(val.toString()).intValue()) : (valType == Long.class ? Long.valueOf(Double.valueOf(val.toString()).longValue()) : (valType == Double.class ? Double.valueOf(val.toString()) : (valType == Float.class ? Float.valueOf(val.toString()) : (valType == Date.class ? DateUtil.getJavaDate((double)((Double)val)) : (ef.fieldType() != Class.class ? ef.fieldType().getMethod("getValue", String.class).invoke(null, val.toString()) : Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + valType.getSimpleName() + "Type")).getMethod("getValue", String.class).invoke(null, val.toString())))))));
                    }
                    catch (Exception ex) {
                        log.info("Get cell value [" + i + "," + column + "] error: " + ex.toString());
                        val = null;
                    }
                    String propertyName = null;
                    if (os[1] instanceof Field) {
                        propertyName = ((Field)os[1]).getName();
                        ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(e.getClass(), (String)propertyName).getWriteMethod(), e, (Object[])new Object[]{val});
                    } else if (os[1] instanceof Method) {
                        String mthodName = ((Method)os[1]).getName();
                        if ("get".equals(mthodName.substring(0, 3))) {
                            propertyName = mthodName.substring(3, mthodName.length());
                            mthodName = "set" + propertyName;
                            propertyName = StringUtils.uncapitalize((String)propertyName);
                        }
                        ReflectionUtils.invokeMethod((Method)cls.getMethod(mthodName, valType), e, (Object[])new Object[]{val});
                    }
                    ConstraintViolationException exception = this.validateProperty(e, propertyName, this.validateGroups);
                    if (exception != null && errors.size() < 10) {
                        errors.add(new ExcelImportException.CellError(i + this.headerNum + 1, ef.sort(), exception));
                        if (errors.size() == 10) {
                            throw new ExcelImportException(errors);
                        }
                    }
                }
                sb.append(val).append(", ");
            }
            dataList.add(e);
            log.debug("Read success: [" + i + "] " + sb.toString());
        }
        if (!errors.isEmpty()) {
            throw new ExcelImportException(errors);
        }
        return dataList;
    }

    private ConstraintViolationException validateProperty(Object object, String propertyName, Class<?> ... groups) {
        Set constraintViolations = validator.validateProperty(object, propertyName, (Class[])groups);
        if (constraintViolations.isEmpty()) {
            return null;
        }
        return new ConstraintViolationException(constraintViolations);
    }

    public void validateGroups(Class<?> ... validateGroups) {
        this.validateGroups = validateGroups;
    }
}

