/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel;

import cn.bestwu.simpleframework.support.excel.ExcelField;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ExcelExport {
    private static Logger log = LoggerFactory.getLogger(ExcelExport.class);
    List<Object[]> annotationList = new ArrayList<Object[]>();
    private SXSSFWorkbook wb;
    private SXSSFSheet sheet;
    private Map<String, CellStyle> styles;
    private int rownum;

    public ExcelExport(Class<?> cls) {
        this(null, cls, 1, new int[0]);
    }

    public ExcelExport(Class<?> cls, int type) {
        this(null, cls, type, new int[0]);
    }

    public ExcelExport(String title, Class<?> cls) {
        this(title, cls, 1, new int[0]);
    }

    public ExcelExport(String title, Class<?> cls, int type, int ... groups) {
        Method[] ms;
        Field[] fs;
        block0: for (Field f : fs = cls.getDeclaredFields()) {
            ExcelField ef = f.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != type) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block1: for (int g : groups) {
                    if (inGroup) continue block0;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        this.annotationList.add(new Object[]{ef, f});
                        continue block1;
                    }
                }
                continue;
            }
            this.annotationList.add(new Object[]{ef, f});
        }
        block3: for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelField ef = m.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != type) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block4: for (int g : groups) {
                    if (inGroup) continue block3;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        this.annotationList.add(new Object[]{ef, m});
                        continue block4;
                    }
                }
                continue;
            }
            this.annotationList.add(new Object[]{ef, m});
        }
        this.annotationList.sort(Comparator.comparingInt(o -> ((ExcelField)o[0]).sort()));
        ArrayList<String> headerList = new ArrayList<String>();
        for (Object[] os : this.annotationList) {
            String[] ss;
            String t = ((ExcelField)os[0]).title();
            if (type == 1 && (ss = StringUtils.split((String)t, (String)"**")) != null && ss.length == 2) {
                t = ss[0];
            }
            headerList.add(t);
        }
        this.initialize(title, headerList);
    }

    public ExcelExport(String title, String[] headers) {
        this.initialize(title, new ArrayList<String>(Arrays.asList(headers)));
    }

    public ExcelExport(String title, List<String> headerList) {
        this.initialize(title, headerList);
    }

    private void initialize(String title, List<String> headerList) {
        int i;
        this.wb = new SXSSFWorkbook(500);
        this.sheet = this.wb.createSheet("Export");
        this.styles = this.createStyles((Workbook)this.wb);
        if (StringUtils.hasText((String)title)) {
            SXSSFRow titleRow = this.sheet.createRow(this.rownum++);
            titleRow.setHeightInPoints(30.0f);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellStyle(this.styles.get("title"));
            titleCell.setCellValue(title);
            this.sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), titleRow.getRowNum(), headerList.size() - 1));
        }
        if (headerList == null) {
            throw new RuntimeException("headerList not null!");
        }
        SXSSFRow headerRow = this.sheet.createRow(this.rownum++);
        headerRow.setHeightInPoints(16.0f);
        for (i = 0; i < headerList.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(this.styles.get("header"));
            String[] ss = StringUtils.split((String)headerList.get(i), (String)"**");
            if (ss != null && ss.length == 2) {
                cell.setCellValue(ss[0]);
                Comment comment = this.sheet.createDrawingPatriarch().createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
                comment.setString((RichTextString)new XSSFRichTextString(ss[1]));
                cell.setCellComment(comment);
            } else {
                cell.setCellValue(headerList.get(i));
            }
            this.sheet.trackAllColumnsForAutoSizing();
            this.sheet.autoSizeColumn(i);
        }
        for (i = 0; i < headerList.size(); ++i) {
            int colWidth = this.sheet.getColumnWidth(i) * 2;
            this.sheet.setColumnWidth(i, colWidth < 3000 ? 3000 : colWidth);
        }
        log.debug("Initialize success.");
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = wb.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setBold(true);
        style.setFont(titleFont);
        styles.put("title", style);
        style = wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.LEFT);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.RIGHT);
        styles.put("data3", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        return styles;
    }

    public Row addRow() {
        return this.sheet.createRow(this.rownum++);
    }

    public Cell addCell(Row row, int column, Object val) {
        return this.addCell(row, column, val, 0, Class.class);
    }

    public Cell addCell(Row row, int column, Object val, int align, Class<?> fieldType) {
        Cell cell = row.createCell(column);
        String cellFormatString = "@";
        try {
            if (val == null) {
                cell.setCellValue("");
            } else if (fieldType != Class.class) {
                cell.setCellValue((String)fieldType.getMethod("setValue", Object.class).invoke(null, val));
            } else if (val instanceof String) {
                cell.setCellValue((String)val);
            } else if (val instanceof Integer) {
                cell.setCellValue((double)((Integer)val).intValue());
                cellFormatString = "0";
            } else if (val instanceof Long) {
                cell.setCellValue((double)((Long)val).longValue());
                cellFormatString = "0";
            } else if (val instanceof Double) {
                cell.setCellValue(((Double)val).doubleValue());
                cellFormatString = "0.00";
            } else if (val instanceof Float) {
                cell.setCellValue((double)((Float)val).floatValue());
                cellFormatString = "0.00";
            } else if (val instanceof Date) {
                cell.setCellValue((Date)val);
                cellFormatString = "yyyy-MM-dd HH:mm";
            } else {
                cell.setCellValue((String)Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + val.getClass().getSimpleName() + "Type")).getMethod("setValue", Object.class).invoke(null, val));
            }
            if (val != null) {
                CellStyle style = this.styles.get("data_column_" + column);
                if (style == null) {
                    style = this.wb.createCellStyle();
                    style.cloneStyleFrom(this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : "")));
                    style.setDataFormat(this.wb.createDataFormat().getFormat(cellFormatString));
                    this.styles.put("data_column_" + column, style);
                }
                cell.setCellStyle(style);
            }
        }
        catch (Exception ex) {
            log.info("Set cell value [" + row.getRowNum() + "," + column + "] error: " + ex.toString());
            cell.setCellValue(val.toString());
        }
        return cell;
    }

    private Object invokeGetter(Object obj, String propertyName) throws NoSuchMethodException {
        Object object = obj;
        for (String name : StringUtils.split((String)propertyName, (String)".")) {
            String getterMethodName = "get" + StringUtils.capitalize((String)name);
            object = ReflectionUtils.invokeMethod((Method)object.getClass().getMethod(getterMethodName, new Class[0]), (Object)object);
        }
        return object;
    }

    public <E> ExcelExport setDataList(List<E> list) {
        for (E e : list) {
            int colunm = 0;
            Row row = this.addRow();
            StringBuilder sb = new StringBuilder();
            for (Object[] os : this.annotationList) {
                ExcelField ef = (ExcelField)os[0];
                Object val = null;
                try {
                    if (StringUtils.hasText((String)ef.value())) {
                        val = this.invokeGetter(e, ef.value());
                    } else if (os[1] instanceof Field) {
                        val = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(e.getClass(), (String)((Field)os[1]).getName()).getReadMethod(), e);
                    } else if (os[1] instanceof Method) {
                        val = ReflectionUtils.invokeMethod((Method)((Method)os[1]), e);
                    }
                }
                catch (Exception ex) {
                    log.info(ex.toString());
                    val = "";
                }
                this.addCell(row, colunm++, val, ef.align(), ef.fieldType());
                sb.append(val).append(", ");
            }
            log.debug("Write success: [" + row.getRowNum() + "] " + sb.toString());
        }
        return this;
    }

    public ExcelExport write(OutputStream os) throws IOException {
        this.wb.write(os);
        return this;
    }

    public ExcelExport write(HttpServletRequest request, HttpServletResponse response, String fileName) throws IOException {
        response.reset();
        String agent = request.getHeader("USER-AGENT");
        fileName = null != agent && (agent.contains("Trident") || agent.contains("Edge")) ? URLEncoder.encode(fileName, "UTF-8") : MimeUtility.encodeText((String)fileName, (String)"UTF8", (String)"B");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xlsx");
        response.setContentType("application/vnd.ms-excel; charset=utf-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        this.write((OutputStream)response.getOutputStream());
        return this;
    }

    public ExcelExport writeFile(String fileName) throws IOException {
        FileOutputStream os = new FileOutputStream(fileName);
        this.write(os);
        return this;
    }

    public ExcelExport dispose() {
        this.wb.dispose();
        return this;
    }
}

