/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support;

import java.io.File;
import org.springframework.util.Assert;

public class FilenameUtil {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String getBaseName(String filename) {
        return FilenameUtil.removeExtension(FilenameUtil.getName(filename));
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FilenameUtil.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FilenameUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FilenameUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getExtension(File file) {
        Assert.notNull((Object)file, (String)"file must not be null");
        String name = file.getName();
        return FilenameUtil.getExtension(name);
    }

    public static String getExtension(String fileName) {
        Assert.notNull((Object)fileName, (String)"fileName must not be null");
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }
}

