/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.data;

import cn.bestwu.simpleframework.data.binding.BinderCustomizer;
import cn.bestwu.simpleframework.data.dsl.EntityPathWrapper;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class RepositoryMetadata {
    private final Object repository;
    private final Map<String, String> cachedFieldsMap;
    private Class<?> modelClass;
    private Class<? extends Serializable> idType;
    private Class<? extends EntityPathWrapper<?, ?>> queryDslType;
    private Method wrapperBinderMethod;
    private Method findOneMethod;

    public RepositoryMetadata(BaseMapper repository, Class<? extends BaseMapper> repositoryInterface) throws NoSuchMethodException, NoSuchFieldException {
        this.repository = repository;
        this.init(repositoryInterface);
        Assert.notNull(this.modelClass, (String)("\u672a\u6210\u529f\u8bbe\u7f6e modelClass\uff0crepository:" + repositoryInterface.getName() + " \u672a\u7ee7\u627f " + BaseMapper.class.getTypeName()));
        this.findOneMethod = repositoryInterface.getMethod("selectById", Serializable.class);
        HashMap<String, String> cachedFieldsMap = new HashMap<String, String>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.modelClass);
        String keyProperty = tableInfo.getKeyProperty();
        cachedFieldsMap.put(keyProperty, tableInfo.getKeyColumn());
        for (TableFieldInfo tableFieldInfo : tableInfo.getFieldList()) {
            cachedFieldsMap.put(tableFieldInfo.getProperty(), tableFieldInfo.getColumn());
        }
        this.idType = this.modelClass.getDeclaredField(keyProperty).getType();
        this.cachedFieldsMap = Collections.unmodifiableMap(cachedFieldsMap);
    }

    private void init(Class<?> repositoryInterface) throws NoSuchMethodException {
        Type[] genericInterfaces = repositoryInterface.getGenericInterfaces();
        boolean hasBinderCustomizer = BinderCustomizer.class.isAssignableFrom(repositoryInterface);
        for (Type genericInterface : genericInterfaces) {
            Type[] typeArguments;
            if (genericInterface instanceof ParameterizedType && ((ParameterizedType)genericInterface).getRawType().getTypeName().equals(BaseMapper.class.getName())) {
                typeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments();
                this.modelClass = (Class)typeArguments[0];
                continue;
            }
            if (hasBinderCustomizer && genericInterface instanceof ParameterizedType && ((ParameterizedType)genericInterface).getRawType().getTypeName().equals(BinderCustomizer.class.getName())) {
                typeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments();
                this.queryDslType = (Class)typeArguments[0];
                this.wrapperBinderMethod = repositoryInterface.getMethod("customize", this.queryDslType);
                break;
            }
            if (!(genericInterface instanceof Class) || ((Class)genericInterface).getGenericInterfaces().length <= 0) continue;
            this.init((Class)genericInterface);
        }
    }

    public Object invokeFindOne(Serializable id) throws InvocationTargetException, IllegalAccessException {
        return this.findOneMethod.invoke(this.repository, id);
    }

    public void invokeCustomize(EntityPathWrapper<?, ?> entityPathWrapper) throws InvocationTargetException, IllegalAccessException {
        if (this.wrapperBinderMethod != null) {
            this.wrapperBinderMethod.invoke(this.repository, new Object[]{entityPathWrapper});
        }
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    public Class<? extends Serializable> getIdType() {
        return this.idType;
    }

    public Method getWrapperBinderMethod() {
        return this.wrapperBinderMethod;
    }

    public Method getFindOneMethod() {
        return this.findOneMethod;
    }

    public Object getRepository() {
        return this.repository;
    }

    public Map<String, String> getCachedFieldsMap() {
        return this.cachedFieldsMap;
    }

    public Class<? extends EntityPathWrapper<?, ?>> getQueryDslType() {
        return this.queryDslType;
    }

    public EntityPathWrapper<?, ?> getWrapper() throws IllegalAccessException, InstantiationException {
        return this.queryDslType == null ? new EntityPathWrapper() : this.queryDslType.newInstance();
    }
}

