/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.config;

import cn.bestwu.lang.packagescan.PackageScanClassResolver;
import cn.bestwu.logging.annotation.NoRequestLogging;
import cn.bestwu.simpleframework.data.Repositories;
import cn.bestwu.simpleframework.data.binding.WrapperBinderProperties;
import cn.bestwu.simpleframework.web.CustomErrorController;
import cn.bestwu.simpleframework.web.ErrorAttributes;
import cn.bestwu.simpleframework.web.filter.OrderedHiddenHttpMethodFilter;
import cn.bestwu.simpleframework.web.filter.OrderedHttpPutFormContentFilter;
import cn.bestwu.simpleframework.web.kaptcha.KaptchaProperties;
import cn.bestwu.simpleframework.web.resolver.ConditionWrapperArgumentResolver;
import cn.bestwu.simpleframework.web.resolver.ModifyModelMethodArgumentResolver;
import cn.bestwu.simpleframework.web.resolver.PagHandlerMethodArgumentResolver;
import cn.bestwu.simpleframework.web.resolver.StringToEnumConverterFactory;
import cn.bestwu.simpleframework.web.serializer.BigDecimalSerializer;
import cn.bestwu.simpleframework.web.serializer.MixIn;
import cn.bestwu.simpleframework.web.xss.XssFilter;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.boot.autoconfigure.web.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
public class MvcConfiguration {
    private Logger log = LoggerFactory.getLogger(MvcConfiguration.class);
    @Value(value="${app.jackson.mix-in-annotation.basePackages:}")
    private String[] basePackages;

    @Bean
    public Module module(ApplicationContext applicationContext) {
        SimpleModule module = new SimpleModule();
        HashSet<String> packages = new HashSet<String>();
        if (this.basePackages.length == 0) {
            for (Object o : applicationContext.getBeansWithAnnotation(ComponentScan.class).values()) {
                ComponentScan annotation = (ComponentScan)AnnotatedElementUtils.findMergedAnnotation(o.getClass(), ComponentScan.class);
                for (Class aClass : annotation.basePackageClasses()) {
                    packages.add(aClass.getPackage().getName());
                }
                packages.addAll(Arrays.asList(annotation.basePackages()));
                if (!packages.isEmpty()) continue;
                packages.add(o.getClass().getPackage().getName());
            }
        }
        packages.add("cn.bestwu.simpleframework");
        this.basePackages = packages.toArray(new String[packages.size()]);
        Set allSubClasses = new PackageScanClassResolver().findImplementations(MixIn.class, this.basePackages);
        for (Class aClass : allSubClasses) {
            ParameterizedType object = (ParameterizedType)aClass.getGenericInterfaces()[0];
            Class targetType = (Class)object.getActualTypeArguments()[0];
            if (this.log.isDebugEnabled()) {
                this.log.debug("setMixInAnnotation:{}=>{}", (Object)targetType, (Object)aClass);
            }
            module.setMixInAnnotation(targetType, aClass);
        }
        return module;
    }

    @Bean
    public OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    @Bean
    public OrderedHttpPutFormContentFilter putFormContentFilter() {
        return new OrderedHttpPutFormContentFilter();
    }

    @Bean
    public XssFilter xssFilter() {
        return new XssFilter();
    }

    @ConditionalOnMissingBean(value={org.springframework.boot.autoconfigure.web.ErrorAttributes.class})
    @Bean
    public ErrorAttributes errorAttributes() {
        return new ErrorAttributes();
    }

    @ConditionalOnMissingBean(value={ErrorController.class})
    @Bean
    public CustomErrorController customErrorController(ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        return new CustomErrorController((org.springframework.boot.autoconfigure.web.ErrorAttributes)errorAttributes, serverProperties.getError());
    }

    @Configuration
    @ConditionalOnWebApplication
    @EnableConfigurationProperties(value={WrapperBinderProperties.class})
    protected static class WebMvcConfigurer
    extends WebMvcConfigurerAdapter {
        private final Repositories repositories;
        private final WrapperBinderProperties properties;

        @Autowired
        public WebMvcConfigurer(Repositories repositories, WrapperBinderProperties properties) {
            this.repositories = repositories;
            this.properties = properties;
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(new PagHandlerMethodArgumentResolver());
            argumentResolvers.add(new ModifyModelMethodArgumentResolver(this.repositories));
            argumentResolvers.add(new ConditionWrapperArgumentResolver(this.repositories, this.properties));
        }

        public void addFormatters(FormatterRegistry registry) {
            registry.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
            registry.addConverter((Converter)new Converter<String, java.util.Date>(){

                public java.util.Date convert(String source) {
                    return new java.util.Date(Long.parseLong(source));
                }
            });
            registry.addConverter((Converter)new Converter<String, Date>(){

                public Date convert(String source) {
                    return new Date(Long.parseLong(source));
                }
            });
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultKaptcha.class})
    @ConditionalOnWebApplication
    @EnableConfigurationProperties(value={KaptchaProperties.class})
    protected static class KaptchaConfiguration {
        protected KaptchaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Producer.class})
        public DefaultKaptcha kaptcha(KaptchaProperties kaptchaProperties) {
            Properties properties = new Properties();
            properties.put("kaptcha.border", kaptchaProperties.getBorder());
            properties.put("kaptcha.textproducer.font.color", kaptchaProperties.getTextproducerFontColor());
            properties.put("kaptcha.textproducer.char.space", (Object)kaptchaProperties.getTextproducerCharSpace());
            Config config = new Config(properties);
            DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
            defaultKaptcha.setConfig(config);
            return defaultKaptcha;
        }

        @Controller
        protected static class CaptchaController {
            private Producer producer;

            public CaptchaController(Producer producer) {
                this.producer = producer;
            }

            @NoRequestLogging
            @GetMapping(value={"/captcha.jpg"})
            public void captcha(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader("Cache-Control", "no-store, no-cache");
                response.setContentType("image/jpeg");
                String text = this.producer.createText();
                BufferedImage image = this.producer.createImage(text);
                request.getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)text);
                ServletOutputStream out = response.getOutputStream();
                ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class ObjectMapperBuilderCustomizer
    implements Jackson2ObjectMapperBuilderCustomizer {
        protected ObjectMapperBuilderCustomizer() {
        }

        public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
            jacksonObjectMapperBuilder.serializerByType(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer());
        }
    }
}

