/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.loader.SQLFileParser;
import org.beetl.sql.xml.XMLBeetlSQL;
import org.beetl.sql.xml.XMLResultMapSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLFileParser
implements SQLFileParser {
    String modelName;
    Reader reader;
    List<SQLSource> list = new ArrayList<SQLSource>();
    int i = 0;

    public XMLFileParser(String modelName, Reader reader) {
        this.modelName = modelName;
        this.reader = reader;
        try {
            this.init();
        }
        catch (BeetlSQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BeetlSQLException(2, "\u89e3\u6790xml\u9519 " + modelName + " error:" + e.getMessage(), (Throwable)e);
        }
    }

    private void init() throws ParserConfigurationException, IOException, SAXException {
        SQLSource sqlSource;
        String id;
        Node node;
        int i;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(new InputSource(this.reader));
        NodeList sqlList = document.getElementsByTagName("sql");
        int len = sqlList.getLength();
        for (i = 0; i < len; ++i) {
            node = sqlList.item(i);
            id = node.getAttributes().item(0).getTextContent();
            StringBuilder sb = new StringBuilder();
            this.parseSqlNode(node, sb);
            sqlSource = new SQLSource();
            sqlSource.id = SqlId.of((String)this.modelName, (String)id);
            sqlSource.template = sb.toString();
            sqlSource.setLine(1);
            this.list.add(sqlSource);
        }
        NodeList resultMapList = document.getElementsByTagName("resultMap");
        len = resultMapList.getLength();
        for (i = 0; i < len; ++i) {
            node = resultMapList.item(i);
            id = node.getAttributes().item(0).getTextContent();
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.parseMapNode(id, node, map);
            sqlSource = new XMLResultMapSource();
            sqlSource.id = SqlId.of((String)this.modelName, (String)id);
            sqlSource.template = null;
            sqlSource.mapConfig = map;
            sqlSource.setLine(1);
            this.list.add(sqlSource);
        }
    }

    public SQLSource next() throws IOException {
        if (this.list.size() == this.i) {
            return null;
        }
        SQLSource sqlSource = this.list.get(this.i);
        ++this.i;
        return sqlSource;
    }

    protected void parseMapNode(String id, Node parent, Map<String, Object> map) {
        NodeList sqlList = parent.getChildNodes();
        for (int i = 0; i < sqlList.getLength(); ++i) {
            String property;
            Node node = sqlList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("result")) {
                property = node.getAttributes().getNamedItem("property").getTextContent();
                String column = node.getAttributes().getNamedItem("column").getTextContent();
                map.put(property, column);
                continue;
            }
            if (node.getNodeName().equals("association") || node.getNodeName().equals("collection")) {
                property = node.getAttributes().getNamedItem("property").getTextContent();
                HashMap<String, Object> childMap = new HashMap<String, Object>();
                this.parseMapNode(id, node, childMap);
                map.put(property, childMap);
                continue;
            }
            throw new BeetlSQLException(25, "\u4e0d\u652f\u6301\u7684xml\u8282\u70b9'" + node.getNodeName() + "' ,\u4f4d\u4e8e " + this.modelName + "." + id);
        }
    }

    protected void parseSqlNode(Node parent, StringBuilder sb) {
        NodeList sqlList = parent.getChildNodes();
        for (int i = 0; i < sqlList.getLength(); ++i) {
            Node node = sqlList.item(i);
            if (node.getNodeType() == 8) continue;
            if (node.getNodeType() == 4) {
                sb.append(node.getTextContent());
                continue;
            }
            if (node.getNodeType() == 1) {
                this.genNodeContent(node, sb);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            String str = node.getTextContent();
            str = StringEscapeUtils.unescapeXml((String)str);
            sb.append(str);
        }
    }

    private void genNodeContent(Node node, StringBuilder sb) {
        String nodeName = "b:" + node.getNodeName();
        sb.append("<").append(nodeName);
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attrNode = namedNodeMap.item(i);
            if (attrNode.getNodeType() != 2) continue;
            Attr attr = (Attr)attrNode;
            String name = attr.getName();
            String value = attr.getValue();
            if (!XMLBeetlSQL.holderSet.contains(node.getNodeName() + "_" + name)) {
                sb.append(" ").append(attr.getName()).append("=").append('\"').append(value).append('\"');
                continue;
            }
            value = this.parseValue(value);
            sb.append(" ").append(attr.getName()).append("=").append("\"#{").append(value).append("}\"");
        }
        if (!node.hasChildNodes()) {
            sb.append("/>");
            return;
        }
        sb.append(">");
        this.parseSqlNode(node, sb);
        sb.append("</").append(nodeName).append(">");
    }

    private String parseValue(String value) {
        value = value.replace(" and ", "&&").replace(" or ", "||");
        return value;
    }
}

