/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beetl.core.ByteWriter;
import org.beetl.core.Configuration;
import org.beetl.core.Function;
import org.beetl.core.GeneralLoopStatus;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ILoopStatus;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.tag.GeneralVarTagBinding;
import org.beetl.core.tag.Tag;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.engine.StringSqlTemplateLoader;
import org.beetl.sql.core.engine.TrimTag;
import org.beetl.sql.core.engine.WhereTag;
import org.beetl.sql.core.engine.template.BeetlTemplateEngine;
import org.beetl.sql.core.loader.AbsolutePathLoader;
import org.beetl.sql.core.loader.MarkdownClasspathLoader;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.ext.PluginExtConfig;
import org.beetl.sql.xml.XMLClasspathLoader;
import org.beetl.sql.xml.XMLTagSupportWrapper;

public class XMLBeetlSQL
implements PluginExtConfig {
    public static Set<String> holderSet = new HashSet<String>();

    public void config(SQLManager sqlManager) {
        SQLLoader sqlLoader = sqlManager.getSqlLoader();
        BeetlTemplateEngine beetlSQLTemplateEngine = (BeetlTemplateEngine)sqlManager.getSqlTemplateEngine();
        if (!(sqlLoader instanceof XMLClasspathLoader)) {
            XMLClasspathLoader xmlClasspathLoader;
            if (sqlLoader instanceof MarkdownClasspathLoader) {
                MarkdownClasspathLoader markdownClasspathLoader = (MarkdownClasspathLoader)sqlLoader;
                xmlClasspathLoader = new XMLClasspathLoader(markdownClasspathLoader.getSqlRoot(), markdownClasspathLoader.getCharset());
                this.changeToXMLLoader(sqlManager, xmlClasspathLoader);
            } else if (sqlLoader instanceof AbsolutePathLoader) {
                AbsolutePathLoader fileLoader = (AbsolutePathLoader)sqlLoader;
                xmlClasspathLoader = new XMLClasspathLoader(fileLoader.getSqlRoot(), fileLoader.getCharset());
                this.changeToXMLLoader(sqlManager, xmlClasspathLoader);
            } else {
                throw new UnsupportedOperationException("\u9700\u8981\u914d\u7f6e XMLClasspathLoader\u624d\u80fd\u4f7f\u7528");
            }
        }
        GroupTemplate gt = beetlSQLTemplateEngine.getBeetl().getGroupTemplate();
        String htmlTagStart = "<b:";
        String htmlTagEnd = "</b:";
        Configuration.HtmlTagHolder tagHolder = new Configuration.HtmlTagHolder(htmlTagStart, htmlTagEnd, "var", true);
        gt.getConf().setTagConf(tagHolder);
        this.registerXMLTag(gt);
        gt.registerTag("htmltag", XMLTagSupportWrapper.class);
    }

    protected void changeToXMLLoader(SQLManager sqlManager, XMLClasspathLoader xmlClasspathLoader) {
        xmlClasspathLoader.setClassLoaderKit(sqlManager.getClassLoaderKit());
        xmlClasspathLoader.setDbStyle(sqlManager.getDbStyle());
        sqlManager.setSqlLoader((SQLLoader)xmlClasspathLoader);
        StringSqlTemplateLoader sqlTemplateLoader = new StringSqlTemplateLoader((SQLLoader)xmlClasspathLoader);
        BeetlTemplateEngine beetlSQLTemplateEngine = (BeetlTemplateEngine)sqlManager.getSqlTemplateEngine();
        beetlSQLTemplateEngine.getBeetl().getGroupTemplate().setResourceLoader((ResourceLoader)sqlTemplateLoader);
    }

    public void registerTag(SQLManager sqlManager, String name, Tag tag) {
        BeetlTemplateEngine beetlSQLTemplateEngine = (BeetlTemplateEngine)sqlManager.getSqlTemplateEngine();
        GroupTemplate gt = beetlSQLTemplateEngine.getBeetl().getGroupTemplate();
        gt.registerTag("name", IfTag.class);
    }

    private void registerXMLTag(GroupTemplate groupTemplate) {
        groupTemplate.registerTag("if", IfTag.class);
        groupTemplate.registerTag("include", Include.class);
        groupTemplate.registerTag("isNotEmpty", IsNotEmpty.class);
        groupTemplate.registerTag("isEmpty", IsEmpty.class);
        groupTemplate.registerTag("isBlank", isBlank.class);
        groupTemplate.registerTag("isNotBlank", IsNotBlank.class);
        groupTemplate.registerTag("foreach", Foreach.class);
        groupTemplate.registerTag("bind", BindTag.class);
        groupTemplate.registerTag("trim", TrimTag.class);
        groupTemplate.registerTag("where", XMLWhereTag.class);
    }

    static {
        holderSet.add("if_test");
        holderSet.add("foreach_items");
        holderSet.add("bind_value");
    }

    public static class Foreach
    extends GeneralVarTagBinding {
        public void render() {
            ILoopStatus it;
            if (!this.containHtmlAttribute("items")) {
                throw new IllegalArgumentException(this.getHtmlTagName() + " \u671f\u671b items\u5c5e\u6027");
            }
            Object value = this.getAttributeValue("items");
            if (value == null) {
                return;
            }
            boolean containStatus = false;
            String str = (String)this.args[2];
            if (str.indexOf(44) != -1) {
                containStatus = true;
            }
            if ((it = GeneralLoopStatus.getIteratorStatus((Object)value)) == null) {
                throw new RuntimeException("\u671f\u671b\u6570\u7ec4\u6216\u8005\u96c6\u5408\uff0c\u5b9e\u9645\u7c7b\u578b\u662f:" + value.getClass());
            }
            try {
                if (this.containHtmlAttribute("open")) {
                    this.ctx.byteWriter.writeString((String)this.getAttributeValue("open"));
                }
                boolean haSeparator = this.containHtmlAttribute("separator");
                String separator = (String)this.getAttributeValue("separator");
                while (it.hasNext()) {
                    Object item = it.next();
                    if (containStatus) {
                        this.binds(new Object[]{item, it});
                    } else {
                        this.binds(new Object[]{item});
                    }
                    this.doBodyRender();
                    if (!haSeparator || it.isLast()) continue;
                    this.ctx.byteWriter.writeString(separator);
                }
                if (this.containHtmlAttribute("close")) {
                    this.ctx.byteWriter.writeString((String)this.getAttributeValue("close"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class IfTag
    extends Tag {
        public void render() {
            if (!this.containHtmlAttribute("test")) {
                throw new IllegalArgumentException("\u7f3a\u5c11 test\u5c5e\u6027");
            }
            Object value = this.getHtmlAttribute("test");
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("\u671f\u671btest\u8868\u8fbe\u5f0f\u8fd0\u7b97\u7ed3\u679c\u662fboolean\u7c7b\u578b");
            }
            if (((Boolean)value).booleanValue()) {
                this.doBodyRender();
            }
        }
    }

    public static class Include
    extends Tag {
        public void render() {
            ByteWriter tempWriter;
            String id = (String)super.getHtmlAttribute("refid");
            Function include = null;
            Object[] paras = null;
            if (id.lastIndexOf(".") == -1) {
                include = this.gt.getFunction("use");
                paras = new Object[]{id};
            } else {
                include = this.gt.getFunction("globalUse");
                paras = new Object[]{id};
            }
            ByteWriter writer = this.ctx.byteWriter;
            this.ctx.byteWriter = tempWriter = this.ctx.byteWriter.getTempWriter(writer);
            include.call(new Object[]{id}, this.ctx);
            this.ctx.byteWriter = writer;
            try {
                this.ctx.byteWriter.fill(tempWriter);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static abstract class GeneralEmptyTag
    extends Tag {
        static StringTemplateResourceLoader stringTemplateResourceLoader = new StringTemplateResourceLoader();

        public void render() {
            String express = (String)this.getHtmlAttribute("value");
            StringWriter sw = new StringWriter();
            Map paras = this.ctx.globalVar;
            String function = this.getFunction();
            Map ret = this.gt.runScript((Object)("return " + function + "(" + express + ");"), paras, (Writer)sw, (ResourceLoader)stringTemplateResourceLoader);
            if (ret.isEmpty()) {
                throw new BeetlSQLException(99, "\u6267\u884c\u8868\u8fbe\u5f0f\u9519\u8bef " + express + " error:" + sw.toString());
            }
            Boolean o = (Boolean)ret.get("return");
            if (o.booleanValue()) {
                this.doBodyRender();
            }
        }

        protected abstract String getFunction();
    }

    public static class isBlank
    extends GeneralEmptyTag {
        @Override
        protected String getFunction() {
            return "isBlank";
        }
    }

    public static class IsNotBlank
    extends GeneralEmptyTag {
        @Override
        protected String getFunction() {
            return "isNotBlank";
        }
    }

    public static class IsNotEmpty
    extends GeneralEmptyTag {
        @Override
        protected String getFunction() {
            return "isNotEmpty";
        }
    }

    public static class IsEmpty
    extends GeneralEmptyTag {
        @Override
        protected String getFunction() {
            return "isEmpty";
        }
    }

    public static class BindTag
    extends GeneralVarTagBinding {
        public void render() {
            Object value = this.getAttributeValue("value");
            this.binds(new Object[]{value});
        }
    }

    public static class XMLWhereTag
    extends WhereTag {
        protected void initTrimArgs(Object[] args) {
            this.prefix = "WHERE";
            this.prefixOverrides = new String[]{"AND ", "OR "};
        }
    }
}

