/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.dynamic;

import com.beetl.sql.dynamic.BaseEntity;
import com.beetl.sql.dynamic.BeanTableAsmCode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;
import org.beetl.core.GroupTemplate;
import org.beetl.core.misc.ByteClassLoader;
import org.beetl.sql.core.SQLManager;

public class DynamicEntityLoader<T> {
    protected SQLManager sqlManager;
    protected Map<String, Class<? extends T>> cache = new ConcurrentHashMap<String, Class<? extends T>>();
    private final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([$_a-zA-Z][$_a-zA-Z0-9]*)\\s*");
    private static Map<String, JavaFileObject> fileObjectMap = new ConcurrentHashMap<String, JavaFileObject>();
    protected String pkg;
    protected Class<T> baseClass;
    protected ByteClassLoader loader = null;

    public DynamicEntityLoader(SQLManager sqlManager) {
        this(sqlManager, "com.test001", BaseEntity.class);
    }

    public DynamicEntityLoader(SQLManager sqlManager, String pkg, Class<T> clazz) {
        this.sqlManager = sqlManager;
        this.pkg = pkg;
        this.baseClass = clazz;
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : GroupTemplate.class.getClassLoader();
        this.loader = new ByteClassLoader(defaultClassLoader);
    }

    public DynamicEntityLoader(SQLManager sqlManager, String pkg, Class<T> clazz, ClassLoader classLoader) {
        this.sqlManager = sqlManager;
        this.pkg = pkg;
        this.baseClass = clazz;
        this.loader = new ByteClassLoader(classLoader);
    }

    public Class<? extends T> getDynamicEntity(String table) {
        return this.getDynamicEntity(table, this.baseClass);
    }

    public Class<? extends T> getDynamicEntity(String table, Class<T> clazz) {
        Class c = this.cache.get(table);
        if (c != null) {
            return c;
        }
        c = this.cache.computeIfAbsent(table, s -> {
            Class<T> newCLass = this.compile((String)s, clazz.getName());
            return newCLass;
        });
        return c;
    }

    protected Class<? extends T> compile(String table, String baseObject) {
        try {
            String className = this.sqlManager.getNc().getClassName(table);
            byte[] classByte = BeanTableAsmCode.genCode(this.sqlManager, table, this.pkg, this.baseClass);
            Class c = this.loader.defineClass(this.pkg + "." + className, classByte);
            return c;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("\u7f16\u8bd1class " + table + " \u9519\u8bef", exception);
        }
    }
}

