/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.dynamic;

import java.lang.reflect.Field;
import java.util.Set;
import org.beetl.ow2.asm.AnnotationVisitor;
import org.beetl.ow2.asm.ClassWriter;
import org.beetl.ow2.asm.FieldVisitor;
import org.beetl.ow2.asm.MethodVisitor;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.SQLManager;

public class BeanTableAsmCode {
    public static byte[] genCode(SQLManager sqlManager, String name, String pkg, Class baseBeanClass) throws Exception {
        String supperName = baseBeanClass.getName().replace('.', '/');
        TableDesc tableDesc = sqlManager.getTableDesc(name);
        if (tableDesc == null) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728 " + name);
        }
        String clsName = sqlManager.getNc().getClassName(name);
        String onwerClass = (pkg + "." + clsName).replace('.', '/');
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 33, onwerClass, null, supperName, null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/beetl/sql/annotation/entity/Table;", true);
        annotationVisitor0.visit("name", (Object)name);
        annotationVisitor0.visitEnd();
        BeanTableAsmCode.genConstruct(classWriter, supperName);
        BeanTableAsmCode.genPrivateFiled(classWriter, sqlManager, tableDesc, baseBeanClass);
        BeanTableAsmCode.genProperty(classWriter, sqlManager, onwerClass, tableDesc, baseBeanClass);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void genProperty(ClassWriter classWriter, SQLManager sqlManager, String clsName, TableDesc tableDesc, Class baseClass) throws Exception {
        Set cols = tableDesc.getCols();
        String owner = clsName;
        for (String col : cols) {
            String attrName = sqlManager.getNc().getPropertyName(col);
            Field f = BeanKit.getField((Class)baseClass, (String)attrName);
            if (f != null) continue;
            ColDesc colDesc = tableDesc.getColDesc(col);
            String javaType = BeanTableAsmCode.getJavaType(colDesc.getSqlType());
            String setterMethod = StringKit.getMethodName((String)attrName, (boolean)javaType.equals("java.lang.Boolean"), (boolean)false);
            String getterMethod = StringKit.getMethodName((String)attrName, (boolean)javaType.equals("java.lang.Boolean"), (boolean)true);
            MethodVisitor methodVisitor = null;
            methodVisitor = classWriter.visitMethod(1, setterMethod, "(" + BeanTableAsmCode.getAsmTypeClassName(javaType) + ")V", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, owner, attrName, BeanTableAsmCode.getAsmTypeClassName(javaType));
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(2, 2);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(1, getterMethod, "()" + BeanTableAsmCode.getAsmTypeClassName(javaType), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, owner, attrName, BeanTableAsmCode.getAsmTypeClassName(javaType));
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(1, 1);
            methodVisitor.visitEnd();
        }
    }

    private static void genPrivateFiled(ClassWriter classWriter, SQLManager sqlManager, TableDesc tableDesc, Class baseClass) throws Exception {
        Set cols = tableDesc.getCols();
        for (String col : cols) {
            AnnotationVisitor annotationVisitor0;
            String attrName = sqlManager.getNc().getPropertyName(col);
            Field f = BeanKit.getField((Class)baseClass, (String)attrName);
            if (f != null) continue;
            ColDesc colDesc = tableDesc.getColDesc(col);
            String javaType = BeanTableAsmCode.getJavaType(colDesc.getSqlType());
            FieldVisitor fieldVisitor = classWriter.visitField(2, attrName, BeanTableAsmCode.getAsmTypeClassName(javaType), null, null);
            if (tableDesc.getIdNames().contains(col)) {
                if (colDesc.isAuto()) {
                    annotationVisitor0 = fieldVisitor.visitAnnotation("Lorg/beetl/sql/annotation/entity/AutoID;", true);
                    annotationVisitor0.visitEnd();
                    continue;
                }
                annotationVisitor0 = fieldVisitor.visitAnnotation("Lorg/beetl/sql/annotation/entity/AssignID;", true);
                annotationVisitor0.visitEnd();
                continue;
            }
            if (!colDesc.isAuto()) continue;
            annotationVisitor0 = fieldVisitor.visitAnnotation("Lorg/beetl/sql/annotation/entity/Auto;", true);
            annotationVisitor0.visitEnd();
        }
    }

    private static String getJavaType(int colType) {
        String javaType = (String)JavaType.mapping.get(colType);
        if (javaType.equals("UNKNOW") || javaType.equals("OBJECT") || javaType.equals("SQLXML")) {
            javaType = "java.lang.Object";
        } else if (javaType.equals("DATE")) {
            javaType = "java.sql.Date";
        } else if (javaType.equals("Timestamp")) {
            javaType = "java.sql.Timestamp";
        } else if (javaType.equals("SPECIAL")) {
            javaType = "java.math.BigDecimal";
        } else if (Character.isUpperCase(javaType.charAt(0))) {
            javaType = "java.lang." + javaType;
        }
        return javaType;
    }

    private static void genConstruct(ClassWriter classWriter, String supperName) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supperName, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private static String getAsmTypeClassName(String name) {
        if (name.equals("byte[]")) {
            return "[B";
        }
        return "L" + name.replace('.', '/') + ";";
    }
}

