/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.pref;

import com.beetl.sql.pref.BeanPropertyAsm;
import com.beetl.sql.pref.BeanPropertyWriteFactory;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;

public class FastBeanProcessor
extends BeanProcessor {
    public <T> List<T> toBeanList(ExecuteContext ctx, ResultSet rs, Class<T> type) throws SQLException {
        if (!rs.next()) {
            return new ArrayList(0);
        }
        List results = this.newList();
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(ctx, type, rsmd, props);
        BeanPropertyAsm beanPropertyAsm = BeanPropertyWriteFactory.getBeanProperty(type);
        do {
            results.add(this.createBean(beanPropertyAsm, ctx, rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    protected <T> T createBean(BeanPropertyAsm beanPropertyAsm, ExecuteContext ctx, ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        Object bean = this.newInstance(type);
        ResultSetMetaData meta = rs.getMetaData();
        SqlId sqlId = ctx.sqlId;
        NameConversion nc = ctx.sqlManager.getNc();
        DBStyle dbStyle = ctx.sqlManager.getDbStyle();
        String dbName = dbStyle.getName();
        int dbType = dbStyle.getDBType();
        ReadTypeParameter tp = new ReadTypeParameter(sqlId, dbName, type, rs, meta, 1, ctx);
        ClassAnnotation ca = ClassAnnotation.getClassAnnotation(type);
        Map attrMap = null;
        AttributeConvert convert = null;
        if (ca.isContainExtAnnotation()) {
            attrMap = ca.getExtAnnotation().getAttributeConvertMap();
        }
        for (int i = 1; i < columnToProperty.length; ++i) {
            Object value;
            if (columnToProperty[i] == -2) continue;
            tp.setIndex(i);
            if (columnToProperty[i] == -1) {
                String key = this.getColName(ctx, meta, i);
                if ((dbType == 2 || dbType == 4) && key.equalsIgnoreCase("beetl_rn") || !(bean instanceof Tail)) continue;
                Tail bean2 = (Tail)bean;
                value = this.noMappingValue(tp);
                key = nc.getPropertyName(type, key);
                bean2.set(key, value);
                continue;
            }
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            value = null;
            if (attrMap != null) {
                convert = (AttributeConvert)attrMap.get(prop.getName());
            }
            if (convert != null) {
                value = convert.toAttr(ctx, type, prop.getName(), rs, i);
            } else {
                tp.setTarget(propType);
                JavaSqlTypeHandler handler = this.getHandler(propType);
                if (handler == null) {
                    handler = this.defaultHandler;
                }
                value = handler.getValue(tp);
            }
            beanPropertyAsm.setValue(columnToProperty[i], bean, value);
        }
        return (T)bean;
    }
}

