/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.pref;

import com.beetl.sql.pref.BeanAsmCode;
import com.beetl.sql.pref.BeanPropertyAsm;
import com.beetl.sql.pref.BeanPropertyAsmWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeetlSQLException;

public class BeanPropertyWriteFactory {
    private static final Map<ClassLoader, ByteClassLoader> classLoaders = new ConcurrentHashMap<ClassLoader, ByteClassLoader>();
    static Map<Class, BeanPropertyAsm> propertyAsmMap = new ConcurrentHashMap<Class, BeanPropertyAsm>();

    public static BeanPropertyAsm getBeanProperty(Class c) {
        BeanPropertyAsm propertyWrite = propertyAsmMap.get(c);
        if (propertyWrite != null) {
            return propertyWrite;
        }
        Class clazz = c;
        synchronized (clazz) {
            try {
                Class<?> enhanceClass;
                propertyWrite = propertyAsmMap.get(c);
                if (propertyWrite != null) {
                    return propertyWrite;
                }
                ClassLoader beanClassLoader = c.getClassLoader();
                byte[] bs = BeanAsmCode.genCode(c);
                String name = BeanAsmCode.getWriteClassName(c);
                ByteClassLoader byteClassLoader = classLoaders.get(beanClassLoader);
                if (byteClassLoader == null) {
                    byteClassLoader = new ByteClassLoader(beanClassLoader);
                    classLoaders.put(beanClassLoader, byteClassLoader);
                }
                if ((enhanceClass = byteClassLoader.findClassByName(name)) == null) {
                    enhanceClass = byteClassLoader.defineClass(name, bs);
                }
                BeanPropertyAsm beanPropertyAsm = (BeanPropertyAsm)enhanceClass.newInstance();
                BeanPropertyAsmWrapper writeWrapper = new BeanPropertyAsmWrapper(beanPropertyAsm);
                propertyAsmMap.put(c, writeWrapper);
                return writeWrapper;
            }
            catch (Exception exception) {
                throw new BeetlSQLException(99, "\u4ee3\u7801\u751f\u6210Bean\u9519\u8bef " + exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public static class ByteClassLoader
    extends ClassLoader {
        public ByteClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }

        public Class<?> findClassByName(String clazzName) {
            try {
                return this.getParent().loadClass(clazzName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

