/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.pref;

import com.beetl.sql.pref.BeanPropertyAsm;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.beetl.ow2.asm.ClassWriter;
import org.beetl.ow2.asm.Label;
import org.beetl.ow2.asm.MethodVisitor;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.PropertyDescriptorWrap;

public class BeanAsmCode {
    static final String supperName = BeanPropertyAsm.class.getName().replace('.', '/');
    static Map<Class, BoxClass> boxMap = new HashMap<Class, BoxClass>();

    public static byte[] genCode(Class bean) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 33, BeanAsmCode.getAsmClassName(BeanAsmCode.getWriteClassName(bean)), null, supperName, null);
        BeanAsmCode.genConstruct(classWriter);
        BeanAsmCode.genPropertyWrite(classWriter, bean);
        BeanAsmCode.genPropertyRead(classWriter, bean);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    protected static void genPropertyWrite(ClassWriter classWriter, Class bean) throws Exception {
        String beanAsmName = BeanAsmCode.getAsmClassName(bean.getName());
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "setValue", "(ILjava/lang/Object;Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, beanAsmName);
        methodVisitor.visitVarInsn(58, 4);
        methodVisitor.visitVarInsn(21, 1);
        PropertyDescriptor[] ps = BeanKit.propertyDescriptors((Class)bean);
        ArrayList<Label> switchLabelList = new ArrayList<Label>(ps.length);
        HashMap<Label, PropertyDescriptorWrap> propertyDescriptorMap = new HashMap<Label, PropertyDescriptorWrap>();
        ArrayList<Integer> labelIndex = new ArrayList<Integer>();
        for (int i = 0; i < ps.length; ++i) {
            PropertyDescriptorWrap propertyDescriptorWrap = new PropertyDescriptorWrap(bean, ps[i], i);
            if (propertyDescriptorWrap.getSetMethod() == null) continue;
            Label label = new Label();
            labelIndex.add(i);
            switchLabelList.add(label);
            propertyDescriptorMap.put(label, propertyDescriptorWrap);
        }
        Label labelEnd = new Label();
        Label labelDefault = new Label();
        methodVisitor.visitLookupSwitchInsn(labelDefault, labelIndex.stream().mapToInt(Integer::valueOf).toArray(), switchLabelList.toArray(new Label[0]));
        boolean isFirst = true;
        for (Label label : switchLabelList) {
            PropertyDescriptorWrap propertyDescriptor = (PropertyDescriptorWrap)propertyDescriptorMap.get(label);
            methodVisitor.visitLabel(label);
            if (isFirst) {
                methodVisitor.visitFrame(1, 1, new Object[]{beanAsmName}, 0, null);
                isFirst = false;
            } else {
                methodVisitor.visitFrame(3, 0, null, 0, null);
            }
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(25, 3);
            String paramAsmDesc = null;
            Class<?> paramType = propertyDescriptor.getProp().getPropertyType();
            if (paramType.isPrimitive()) {
                BoxClass boxType = BeanAsmCode.getPrimitiveBoxType(paramType);
                String typeAsmName = BeanAsmCode.getAsmClassName(boxType.getType().getName());
                methodVisitor.visitTypeInsn(192, typeAsmName);
                methodVisitor.visitMethodInsn(182, typeAsmName, boxType.getValueMethod(), "()" + boxType.valueMethodRetType, false);
                paramAsmDesc = "(" + boxType.valueMethodRetType + ")";
            } else {
                String typeAsmName = BeanAsmCode.getAsmClassName(paramType.getName());
                methodVisitor.visitTypeInsn(192, typeAsmName);
                paramAsmDesc = "(L" + typeAsmName + ";)";
            }
            Class<?> clss = propertyDescriptor.getSetMethod().getReturnType();
            String retTypeDesc = "V";
            if (clss != Void.TYPE) {
                retTypeDesc = "L" + BeanAsmCode.getAsmClassName(clss.getName()) + ";";
            }
            methodVisitor.visitMethodInsn(182, beanAsmName, propertyDescriptor.getSetMethod().getName(), paramAsmDesc + retTypeDesc, false);
            if (clss != Void.TYPE) {
                methodVisitor.visitInsn(87);
            }
            methodVisitor.visitJumpInsn(167, labelEnd);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, BeanAsmCode.getAsmClassName(BeanPropertyAsm.class.getName()), "throwException", "(ILjava/lang/Object;)Ljava/lang/RuntimeException;", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(labelEnd);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 5);
        methodVisitor.visitEnd();
    }

    protected static void genPropertyRead(ClassWriter classWriter, Class bean) throws Exception {
        String beanAsmName = BeanAsmCode.getAsmClassName(bean.getName());
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "getValue", "(ILjava/lang/Object;)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, beanAsmName);
        methodVisitor.visitVarInsn(58, 3);
        methodVisitor.visitVarInsn(21, 1);
        PropertyDescriptor[] ps = BeanKit.propertyDescriptors((Class)bean);
        ArrayList<Label> switchLabelList = new ArrayList<Label>(ps.length);
        HashMap<Label, PropertyDescriptorWrap> propertyDescriptorMap = new HashMap<Label, PropertyDescriptorWrap>();
        ArrayList<Integer> labelIndex = new ArrayList<Integer>();
        for (int i = 0; i < ps.length; ++i) {
            PropertyDescriptorWrap propertyDescriptorWrap = new PropertyDescriptorWrap(bean, ps[i], i);
            Label label = new Label();
            labelIndex.add(i);
            switchLabelList.add(label);
            propertyDescriptorMap.put(label, propertyDescriptorWrap);
        }
        Label labelDefault = new Label();
        methodVisitor.visitLookupSwitchInsn(labelDefault, labelIndex.stream().mapToInt(Integer::valueOf).toArray(), switchLabelList.toArray(new Label[0]));
        boolean isFirst = true;
        for (Label label : switchLabelList) {
            PropertyDescriptorWrap propertyDescriptor = (PropertyDescriptorWrap)propertyDescriptorMap.get(label);
            methodVisitor.visitLabel(label);
            if (isFirst) {
                methodVisitor.visitFrame(1, 1, new Object[]{beanAsmName}, 0, null);
                isFirst = false;
            } else {
                methodVisitor.visitFrame(3, 0, null, 0, null);
            }
            methodVisitor.visitVarInsn(25, 3);
            Class<?> paramType = propertyDescriptor.getProp().getPropertyType();
            if (paramType.isPrimitive()) {
                BoxClass boxType = BeanAsmCode.getPrimitiveBoxType(paramType);
                methodVisitor.visitMethodInsn(182, beanAsmName, propertyDescriptor.getProp().getReadMethod().getName(), "()" + boxType.valueMethodRetType, false);
                String paramAsmDesc = "(" + boxType.valueMethodRetType + ")L" + BeanAsmCode.getAsmClassName(boxType.getType().getName()) + ";";
                methodVisitor.visitMethodInsn(184, BeanAsmCode.getAsmClassName(boxType.getType().getName()), "valueOf", paramAsmDesc, false);
            } else {
                String typeAsmName = BeanAsmCode.getAsmClassName(propertyDescriptor.getProp().getPropertyType().getName());
                methodVisitor.visitMethodInsn(182, beanAsmName, propertyDescriptor.getProp().getReadMethod().getName(), "()L" + typeAsmName + ";", false);
            }
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitLabel(labelDefault);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, BeanAsmCode.getAsmClassName(BeanPropertyAsm.class.getName()), "throwException", "(ILjava/lang/Object;)Ljava/lang/RuntimeException;", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(3, 4);
        methodVisitor.visitEnd();
    }

    protected static void genConstruct(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supperName, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    protected static BoxClass getPrimitiveBoxType(Class type) {
        BoxClass boxClass = boxMap.get(type);
        if (boxClass == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u539f\u59cb\u7c7b\u578b " + type.getName() + " \u9700\u8981\u6539\u6210\u5c01\u88c5\u7c7b\u578b");
        }
        return boxClass;
    }

    public static String getWriteClassName(Class bean) {
        return bean.getName() + "$ASM";
    }

    public static String getAsmClassName(String name) {
        return name.replace('.', '/');
    }

    static {
        boxMap.put(Integer.TYPE, new BoxClass(Integer.class, "intValue", "I"));
        boxMap.put(Double.TYPE, new BoxClass(Double.class, "doubleValue", "D"));
        boxMap.put(Long.TYPE, new BoxClass(Long.class, "longValue", "J"));
        boxMap.put(Short.TYPE, new BoxClass(Short.class, "shortValue", "S"));
        boxMap.put(Byte.TYPE, new BoxClass(Byte.class, "byteValue", "B"));
    }

    static class BoxClass {
        Class type;
        String valueMethod;
        String valueMethodRetType;

        public BoxClass(Class boxType, String boxValueMethod, String boxValueMethodRetType) {
            this.type = boxType;
            this.valueMethod = boxValueMethod;
            this.valueMethodRetType = boxValueMethodRetType;
        }

        public Class getType() {
            return this.type;
        }

        public String getValueMethod() {
            return this.valueMethod;
        }

        public String getValueMethodRetType() {
            return this.valueMethodRetType;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public void setValueMethod(String valueMethod) {
            this.valueMethod = valueMethod;
        }

        public void setValueMethodRetType(String valueMethodRetType) {
            this.valueMethodRetType = valueMethodRetType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BoxClass)) {
                return false;
            }
            BoxClass other = (BoxClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class this$type = this.getType();
            Class other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$valueMethod = this.getValueMethod();
            String other$valueMethod = other.getValueMethod();
            if (this$valueMethod == null ? other$valueMethod != null : !this$valueMethod.equals(other$valueMethod)) {
                return false;
            }
            String this$valueMethodRetType = this.getValueMethodRetType();
            String other$valueMethodRetType = other.getValueMethodRetType();
            return !(this$valueMethodRetType == null ? other$valueMethodRetType != null : !this$valueMethodRetType.equals(other$valueMethodRetType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BoxClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $valueMethod = this.getValueMethod();
            result = result * 59 + ($valueMethod == null ? 43 : $valueMethod.hashCode());
            String $valueMethodRetType = this.getValueMethodRetType();
            result = result * 59 + ($valueMethodRetType == null ? 43 : $valueMethodRetType.hashCode());
            return result;
        }

        public String toString() {
            return "BeanAsmCode.BoxClass(type=" + this.getType() + ", valueMethod=" + this.getValueMethod() + ", valueMethodRetType=" + this.getValueMethodRetType() + ")";
        }
    }
}

