package cn.benma666.vo;

import cn.benma666.iframe.Conf;
import com.alibaba.fastjson.util.TypeUtils;

/**
 * 智能交换线程池配置
 */
public class ZnjhTPConfig extends TPConfig {

    @Override
    public Integer getCorePoolSize() {
        return valByDef(corePoolSize, TypeUtils.castToInt(Conf.getVal(
                "benma666.znjh.thread-pool.core-pool-size","5")));
    }

    public Integer getKeepAliveSeconds() {
        return valByDef(keepAliveSeconds, TypeUtils.castToInt(Conf.getVal(
                "benma666.znjh.thread-pool.keep-alive-seconds","600")));
    }

    public Integer getMaxPoolSize() {
        return valByDef(maxPoolSize, TypeUtils.castToInt(Conf.getVal(
                "benma666.znjh.thread-pool.max-pool-size","5")));
    }

    public Integer getQueueCapacity() {
        return valByDef(queueCapacity, TypeUtils.castToInt(Conf.getVal(
                "benma666.znjh.thread-pool.queue-capacity","20000")));
    }
}
