package cn.benma666.sjzt.kafka;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import lombok.Getter;
import lombok.Setter;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;

import java.util.Properties;

import static org.apache.kafka.clients.consumer.ConsumerConfig.*;

@Getter
@Setter
public class KafkaClient {

    //控制台
    private AdminClient adminClient;
    //生产者
    private KafkaProducer kafkaProducer;
    //消费者
    private KafkaConsumer kafkaConsumer;

    public KafkaClient(SysSjglSjzt sjzt) {
        this.adminClient = createAdminClient(sjzt);
        this.kafkaProducer = createProducer(sjzt);
        this.kafkaConsumer = createConsumer(sjzt);
    }

    /**
     * 关闭控制台/生产者/消费者
     */
    public void close() {
        this.adminClient.close();
        this.kafkaProducer.close();
        this.kafkaConsumer.close();
    }

    /**
     * 通过载体创建控制台
     *
     * @param sjzt 数据载体
     * @return 控制台
     */
    public static AdminClient createAdminClient(SysSjglSjzt sjzt) {
        Properties conf = new Properties();
        String servers = sjzt.getLjc();
        conf.setProperty("sasl.mechanism","PLAIN");
        conf.setProperty("sasl.jaas.config","org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
//        properties.setProperty("sasl.jaas.config","org.apache.kafka.common.security.plain.PlainLoginModule required username=admin password=admin;");
        conf.setProperty("security.protocol","SASL_PLAINTEXT");
        conf.setProperty(AdminClientConfig.BOOTSTRAP_SERVERS_CONFIG, servers);
        if(sjzt.getKzxxObj().containsKey("adminConfig")){
            conf.putAll(sjzt.getKzxxObj().getJSONObject("adminConfig"));
        }
        return AdminClient.create(conf);
    }

    /**
     * 通过数据载体创建 生产者
     *
     * @param sjzt 数据载体
     * @return 生产者
     */
    public static KafkaProducer<String, String> createProducer(SysSjglSjzt sjzt) {
        Properties conf = new Properties();
        String servers = sjzt.getLjc();
        if (servers == null) {
            throw new MyException("kafka servers 为空,构造配置对象失败");
        }
        conf.put("bootstrap.servers", servers);
        conf.setProperty("sasl.mechanism","PLAIN");
        conf.setProperty("sasl.jaas.config","org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
        conf.setProperty("security.protocol","SASL_PLAINTEXT");
        conf.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        conf.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        if(sjzt.getKzxxObj().containsKey("producerConfig")){
            conf.putAll(sjzt.getKzxxObj().getJSONObject("producerConfig"));
        }
        return new KafkaProducer<>((conf));
    }

    /**
     * 通过数据载体创建 消费者
     *
     * @param sjzt 数据载体
     * @return 消费者
     */
    public static KafkaConsumer<String, String> createConsumer(SysSjglSjzt sjzt) {
        String servers = sjzt.getLjc();
        if (servers == null) {
            throw new MyException("kafka servers 为空,构造配置对象失败");
        }
        Properties conf = new Properties();
        conf.setProperty(BOOTSTRAP_SERVERS_CONFIG, servers);
        conf.setProperty("sasl.mechanism","PLAIN");
        conf.setProperty("sasl.jaas.config","org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
        conf.setProperty("security.protocol","SASL_PLAINTEXT");
        conf.setProperty(GROUP_ID_CONFIG, sjzt.getDxgsNew());
        conf.setProperty(KEY_DESERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringDeserializer");
        conf.setProperty(VALUE_DESERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringDeserializer");
        if(sjzt.getKzxxObj().containsKey("consumerConfig")){
            conf.putAll(sjzt.getKzxxObj().getJSONObject("consumerConfig"));
        }
        return new KafkaConsumer<>((conf));
    }
}
