package cn.benma666.sjzt.ftp;

import cn.benma666.sjzt.BasicFile;
import cn.benma666.sjzt.BasicSjzt;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.net.ftp.FTPFile;

@Getter
@Setter
public class FtpFile extends BasicFile {
    /**
     * 文件对象
     */
    private FTPFile file;

    public FtpFile(String parent, FTPFile file, BasicSjzt sjzt) {
        super(parent,sjzt);
        this.file = file;
    }

    @Override
    public String getName() {
        return file.getName();
    }

    @Override
    public void setName(String name) {
        file.setName(name);
    }

    @Override
    public boolean isDirectory() {
        return file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return file.isFile();
    }

    @Override
    public long lastModified() {
        return file.getTimestamp().getTimeInMillis();
    }
}
