package cn.benma666.sjzt.fastdfs;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;
import org.csource.fastdfs.*;

import java.io.IOException;
import java.util.Properties;

@Getter
@Setter
public class FastDFSClient extends BasicObject {

    private TrackerServer trackerServer;

    private StorageClient storageClient;

    public FastDFSClient(SysSjglSjzt sjzt) {
        this.storageClient = CreateStorageClient(sjzt);
    }

    /**
     * 关闭连接
     */
    public void close() {
        try {
            trackerServer.close();
        } catch (IOException e) {
            slog.debug("fastdfs连接关闭失败",e);
        }
    }

    /**
     * 创建fastDFS连接
     * @param sjzt
     * @return
     */
    public StorageClient CreateStorageClient(SysSjglSjzt sjzt) {
        JSONObject kzxx = sjzt.getKzxxObj();
        Properties properties = new Properties();
        properties.setProperty("fastdfs.connect_timeout_in_seconds", "2");
        properties.setProperty("fastdfs.network_timeout_in_seconds", "30");
        properties.setProperty("fastdfs.charset", "UTF-8");
        properties.setProperty("fastdfs.http_tracker_http_port", "8080");
        properties.setProperty("fastdfs.http_anti_steal_token", "no");
        properties.setProperty("fastdfs.http_secret_key", "FastDFS1234567890");
        properties.setProperty("fastdfs.tracker_servers", sjzt.getLjc());
        if (kzxx.containsKey("fastdfsConfig")) {
            properties.putAll(sjzt.getKzxxObj().getJSONObject("fastdfsConfig"));
        }
        try {
            ClientGlobal.initByProperties(properties);
            TrackerClient trackerClient = new TrackerClient();
            trackerServer = trackerClient.getConnection();
            StorageServer storageServer = trackerClient.getStoreStorage(trackerServer);
            return new StorageClient(trackerServer, storageServer);
        } catch (Exception e) {
            throw new MyException("fastDFS初始化失败",e);
        }
    }

}
