package cn.benma666.sjzt.bdwj;

import cn.benma666.myutils.FileUtil;
import cn.benma666.sjzt.BasicFile;
import cn.benma666.sjzt.BasicSjzt;
import lombok.Getter;
import lombok.Setter;

import java.io.File;

@Setter
@Getter
public class BdwjFile extends BasicFile {
    /**
     * 文件对象
     */
    private File file;

    public BdwjFile(String parent, File file, BasicSjzt sjzt) {
        super(parent,sjzt);
        this.file = file;
    }
    public BdwjFile(String parent, String file,BasicSjzt sjzt) {
        super(parent,sjzt);
        this.file = new File(file);
    }
    public BdwjFile(String parent, String file) {
        super(parent,null);
        this.file = new File(file);
    }

    @Override
    public String getName() {
        return file.getName();
    }

    @Override
    public void setName(String name) {
        file = new File(FileUtil.getFilePath(file.getParent(),name));
    }

    @Override
    public boolean isDirectory() {
        return file.isDirectory();
    }
    @Override
    public boolean isFile() {
        return file.isFile();
    }
    @Override
    public long lastModified(){
        return file.lastModified();
    }
}
