package cn.benma666.sjzt;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglFile;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.myutils.WebUtil;
import io.minio.*;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.client.methods.HttpGet;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;

/***
 * minio使用工具
 */
public class Minio extends BasicSjzt {

    private static Minio minio = null;

    private final GenericObjectPool genericObjectPool;

    protected Minio(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        GenericObjectPoolConfig<MinioClient> conf = new GenericObjectPoolConfig();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(2);
        conf.setMaxIdle(5);
        conf.setMaxTotal(20);
        conf.setMaxWait(Duration.ofSeconds(300L));
        this.genericObjectPool = new GenericObjectPool(new SjztPooledObjectFactory(sjzt), conf);
        MinioClient minioClient = null;

        try {
            minioClient = (MinioClient) this.genericObjectPool.borrowObject();
        } catch (Exception e) {
            log.error("minio池初始化失败:{}",e);
            throw new MyException(name + "minio池初始化失败", e);
        } finally {
            this.genericObjectPool.returnObject(minioClient);
        }

        if (minio == null) {
            minio = this;
        }
        cache.put(name,this);
    }

    public List<IFile> listFiles(SysSjglZnjh sysSjglZnjh) throws Exception {
        throw new MyException("不支持listFiles");
    }

    public static Minio use(String name) {
        Minio sjzt = (Minio)cache.get(name);
        if (sjzt == null) {
            sjzt = new Minio(name, getSjzt(name));
        }
        return sjzt;
    }

    public static MinioClient createClient(SysSjglSjzt sjzt) {
        try {
            return MinioClient.builder()
                    .endpoint(sjzt.getLjc())
                    .credentials(sjzt.getYhm(), sjzt.getMm())
                    .build();
        } catch (Exception e) {
            slog.error("minioClient初始化失败:{}", e);
            throw new MyException("minioClient初始化失败", e);
        }
    }
    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        //不需要关闭
    }

    public InputStream getInputStream(IFile file) throws Exception {
        return (InputStream) this.exec((minio) -> {
            HttpUtil hu = HttpUtil.builder().addRp(HttpUtil.REQUEST_METHOD, HttpGet.METHOD_NAME).build();
            return hu.getInputStream(this.getAbsolutePath(file));
        });
    }

    /***
     *  执行
     */
    public Object exec(SjztExecRunnable<MinioClient> exec) {
        MinioClient minioClient = null;
        Object obj;
        try {
            minioClient = (MinioClient) this.genericObjectPool.borrowObject();
            obj = exec.exec(minioClient);
        } catch (Exception e) {
            throw new MyException("minio执行异常", e);
        } finally {
            if (minioClient != null) {
                this.genericObjectPool.returnObject(minioClient);
            }
        }
        return obj;
    }


    /***
     * 删除文件
     */
    public boolean delete(IFile file) throws Exception {
        return (Boolean) this.exec((minioClient) -> {
            DbFile dbfile = (DbFile) file;
            //桶名称
            String bucketName = dbfile.getParent();
            minioClient.removeObject(RemoveObjectArgs.builder()
                    .bucket(bucketName)
                    .object(dbfile.getName())
                    .build());
            return true;
        });
    }

    /***
     * 上传文件
     */
    public boolean save(InputStream is, IFile file) throws Exception {
        if(!(file instanceof DbFile)){
            throw new MyException("minio保存文件只支持传入DbFile");
        }
        try {
            return (Boolean) this.exec((minioClient) -> {
                DbFile dbfile = (DbFile) file;
                SysSjglFile sysSjglFile = dbfile.getFile();
                //桶名称
                String bucketName = dbfile.getParent();
                //文件名称
                String fileName = sysSjglFile.getWjm();
                // 检查存储桶是否已经存在 不存在创建
                if (!minioClient.bucketExists(BucketExistsArgs.builder().bucket(bucketName).build())) {
                    minioClient.makeBucket(MakeBucketArgs.builder().bucket(bucketName).build());
                }
                //上传
                PutObjectArgs objectArgs = PutObjectArgs.builder().object(fileName)
                        .bucket(bucketName)
                        .contentType(WebUtil.CONTENTTYPE_APPLICATION_STREAM)
                        .stream(is, is.available(), -1).build();
                minioClient.putObject(objectArgs);
                //获取扩展信息 展示地址
                String fileUrl = bucketName + UtilConst.FXG + sysSjglFile.getWjm();
                log.info("minio上传地址：{}", fileUrl);
                if (!isBlank(fileUrl)) {
                    sysSjglFile.setSclj(fileUrl);
                    sysSjglFile.setParent(bucketName);
                    return true;
                } else {
                    return false;
                }
            });
        } finally {
            FileUtil.closeStream(is);
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            MinioClient minioClient = createClient(sjzt);
            minioClient.listBuckets();
            return success("测试成功");
        } catch (Throwable t) {
            slog.debug("{}测试失败", sjzt, t);
            return failed("载体测试不通过：" + t.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            MinioClient minioClient = (MinioClient)client;
            //api调用 查询桶列表
            minioClient.listBuckets();
            return true;
        } catch (Exception e) {
            slog.debug("minioClient验证无效：{}", sjzt.getMc(), e);
            return false;
        }
    }

    public String getRootPath() {
        return sjzt.getKzxxObj().getString("$.config.server_url");
    }

    //绝对路径
    public String getAbsolutePath(IFile file) {
        DbFile dbfile = (DbFile)file;
        SysSjglFile sysSjglFile = dbfile.getFile();
        return sysSjglFile.getSclj();
    }

    public long getSize(IFile iFile) throws Exception {
        return iFile.length();
    }

    public void close() throws IOException {
        if (!this.genericObjectPool.isClosed()) {
            this.genericObjectPool.close();
        }
        cache.remove(this.name);
        if (this == minio) {
            minio = null;
        }
    }
    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        throw new BusinessException("Minio不支持监听");
    }

    @Override
    public String getUrl(IFile ifile) {
        if(ifile instanceof DbFile){
            return UtilConst.FXG+this.name+UtilConst.FXG+((DbFile) ifile).getFile().getSclj();
        }
        return super.getUrl(ifile);
    }

    @Override
    public boolean zcUrl(IFile iFile) {
        return iFile instanceof DbFile;
    }
}
