package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import com.alibaba.druid.util.Utils;

import java.io.InputStream;
import java.util.regex.Pattern;

/**
 * 文件抽象
 */
public interface IFile {
    /**
     * 穿透调用结果文件前缀
     */
    String RESULT = "result_";
    /**
     * 精准网闸接收文件名正则
     */
    Pattern jswjPattern = Pattern.compile("^([0-9]+)_([0-9]+)_([0-9]+)_(.*)$");

    /**
     * @return 文件名
     */
    String getName();

    /**
     * 设置文件名
     * @param name 文件名
     */
    void setName(String name);
    /**
     * @return 是否目录
     */
    boolean isDirectory();
    /**
     * @return 是否文件
     */
    boolean isFile();
    /**
     * @return 文件大小
     */
    default long length() {
        try {
            if(getSize()>0){
                return getSize();
            }
            return getSjzt().getSize(this);
        } catch (MyException e) {
            throw e;
        } catch (Exception e) {
            throw new MyException("获取文件大小异常："+e.getMessage(),e);
        }
    }

    /**
     * @return 文件最后修改时间
     */
    long lastModified();
    /**
     * @param xwjdd 小文件等待毫秒
     * @param dwjdd 大文件等待毫秒
     * @return 文件大小
     */
    default long length(long xwjdd, long dwjdd) {
        return FileUtil.getFilelength(this,xwjdd,dwjdd);
    }

    /**
     * 设置父路径
     * @param parent 相对工作目录的父路径
     */
    void setParent(String parent);
    /**
     * @return 相对工作目录的父路径
     */
    String getParent();
    /**
     * @return 工作目录
     */
    String getGzml();
    /**
     * 设置工作目录
     */
    void setGzml(String gzml);
    /**
     * @return 工作目录
     */
    long getSize();
    /**
     * 设置工作目录
     */
    void setSize(long gzml);
    /**
     * @return 文件的数据载体
     */
    BasicSjzt getSjzt();

    /**
     * 设置数据载体
     * @param sjzt 数据载体
     */
    void setSjzt(BasicSjzt sjzt);
    /**
     * @return 相对载体的路径
     */
    default String getPath() {
        return FileUtil.getFilePath(getParent(),getName());
    }

    /**
     * @return 文件在该载体下的绝对路径
     */
    default String getAbsolutePath(){
        if(getSjzt()==null){
            throw new MyException("未设置数据载体");
        }
        return getSjzt().getAbsolutePath(this);
    }

    /**
     * 删除文件
     */
    default boolean delete() throws Exception {
        return getSjzt().delete(this);
    }

    /**
     * 获取文件流
     */
    default InputStream getInputStream() throws Exception {
        if(getSjzt()==null){
            throw new MyException("未设置数据载体");
        }
        return getSjzt().getInputStream(this);
    }

    /**
     * 获取字节
     */
    default byte[] getBytes() throws Exception {
        InputStream in = getInputStream();
        try {
            return Utils.readByteArray(in);
        }finally {
            FileUtil.closeStream(in);
        }
    }

    /**
     * 保存文件
     * @param in 输入流
     * @return 保存状态
     */
    default boolean save(InputStream in){
        if(getSjzt()==null){
            throw new MyException("未设置数据载体");
        }
        try {
            return getSjzt().save(in,this);
        } catch (Exception e) {
            throw new MyException("文件保存失败："+getAbsolutePath(),e);
        }
    }

    /**
     * @return 数据库文件对象
     */
    default SysSjglFile toSjglFile(){
        SysSjglFile f = new SysSjglFile(getAbsolutePath(), getSjzt().getName());
        f.setId(StringUtil.getUUIDUpperStr());
        f.setParent(getParent());
        return f;
    }

    /**
     * @return 直接访问路径
     */
    default String getUrl(){
        if(getSjzt()==null){
            throw new MyException("未设置数据载体");
        }
        try {
            return getSjzt().getUrl(this);
        } catch (Exception e) {
            throw new MyException("文件直接访问路径获取失败："+getAbsolutePath(),e);
        }
    }
    /**
     * 支持获取直接访问文件的url
     */
    default boolean zcUrl(){
        if(getSjzt()==null){
            throw new MyException("未设置数据载体");
        }
        try {
            return getSjzt().zcUrl(this);
        } catch (Exception e) {
            throw new MyException("文件直接访问路径获取失败："+getAbsolutePath(),e);
        }
    }
}
