package cn.benma666.sjzt;

import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.Result;
import lombok.Getter;
import lombok.Setter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

import static cn.benma666.myutils.FileUtil.getFilePath;

@Setter
@Getter
public abstract class BasicFile extends BasicObject implements IFile{
    /**
     * 穿透调用集合
     */
    public static Map<String, Lock> ctdyMap = Collections.synchronizedMap(new HashMap<>());
    /**
     * 穿透调用条件集合
     */
    public static Map<String, Condition> ctdyCondMap = Collections.synchronizedMap(new HashMap<>());
    /**
     * 穿透结果集合
     */
    public static Map<String, Result> ctjgMap = Collections.synchronizedMap(new HashMap<>());
    /**
     * 相对载体的父路径
     */
    private String parent;
    /**
     * 工作目录
     */
    private String gzml;
    /**
     * 数据载体
     */
    protected BasicSjzt sjzt;
    /**
     * 文件大小
     */
    protected long size;

    public BasicFile(String parent, BasicSjzt sjzt) {
        setParent(parent);
        this.sjzt = sjzt;
    }

    public void setParent(String parent) {
        this.parent = getFilePath(parent);
    }

    public void setGzml(String gzml) {
        this.gzml = getFilePath(gzml);
    }
}
