package cn.benma666.myutils;

import cn.benma666.constants.Charset;
import cn.benma666.dict.Xzms;
import cn.benma666.domain.SysSjglFile;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.DictManager;
import cn.benma666.iframe.PageInfo;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebUtil extends BasicObject{
	/**
	 * 文件
	 */
	public static final String CONTENTTYPE_APPLICATION_STREAM = "application/octet-stream";
	public static final String CONTENTTYPE_APPLICATION_EXCEL = "application/vnd.ms-excel";
	public static final String CONTENTTYPE_APPLICATION_JSON = "application/json";
	public static final String CONTENTTYPE_TEXTHTML = "text/html";
	public static final String CONTENTTYPE_TEXTJSON = "text/json";
	public static final String CONTENTTYPE_TEXTXML = "text/xml";
	public static final String CONTENTTYPE_TEXT = "text/plain";

	public static void sendText(HttpServletResponse response, String s) {
		sendDirectToClient(response,s,CONTENTTYPE_TEXT, Charset.UTF_8.getCode());
	}
	/**
	* json字符串 <br/>
	* @author jingma
	* @param response
	* @param s
	*/
	public static void sendJson(HttpServletResponse response, String s) {
		sendDirectToClient(response,s,CONTENTTYPE_TEXTJSON,Charset.UTF_8.getCode());
	}
    /**
    * 对象序列化为json <br/>
    * @author jingma
    * @param response
    * @param o
    */
    public static void sendJson(HttpServletResponse response, Object o) {
		String data;
		if(o instanceof JSON){
			data = o.toString();
		}else {
			//空属性输出：SerializerFeature.WriteMapNullValue,
			data = JSON.toJSONString(o,
					SerializerFeature.DisableCircularReferenceDetect);
		}
        sendDirectToClient(response,data,CONTENTTYPE_TEXTJSON,Charset.UTF_8.getCode());
    }

	public static void sendDirectToClient(HttpServletResponse resp, String s, String contentType, String charset) {
		String charsetPrefix = ";charset=";
		String contentHead = contentType + charsetPrefix + charset;
		resp.setContentType(contentHead);
        PrintWriter writer = null;
		try {
		    writer = resp.getWriter();
			writer.write(s);
            writer.flush();
		} catch (IOException e) {
			slog.debug("像前端发送数据失败:"+e.getMessage());
		}finally{
		    if(writer!=null){
	            try {
	                writer.close();
	            } catch (Exception e) {
	                slog.debug("流关闭失败:"+e.getMessage());
	            }
		    }
		}
	}
	/**
	* 将字节数组以文件下载的形式输出 <br/>
	* @author jingma
	* @param resp
	* @param data 字节数组
    * @param fileObj 文件对象
	*/
	public static void sendBytes(HttpServletResponse resp, byte[] data, SysSjglFile fileObj) {
		ServletOutputStream so = null;
		try {
	        setFileDownloadHead(resp, fileObj);
			so = resp.getOutputStream();
            // 声明比特数组
            resp.setContentLength(data.length);
			so.write(data);
		} catch (Exception e) {
		    slog.debug("文件下载失败:"+e.getMessage());
		} finally {
			// 关闭输出流
			try {
				so.flush();
				so.close();
			} catch (Exception e) {
	            slog.debug("流关闭失败:"+e.getMessage());
			}
		}
	}
    /**
    * 设置文件下载头 <br/>
    * @author jingma
    * @param resp
    * @param fileObj
    * @throws UnsupportedEncodingException
    */
    public static void setFileDownloadHead(HttpServletResponse resp, SysSjglFile fileObj)
            throws UnsupportedEncodingException {
        String type = CONTENTTYPE_APPLICATION_STREAM;
        if(StringUtil.isNotBlank(fileObj.getWjlx())&&fileObj.getXzms()== Xzms.AWJLXXZ.getCode()){
            type = DictManager.zdMcByDm("SYS_COMMON_XZTLX", fileObj.getWjlx());
            if(fileObj.getWjlx().equals(type)){
				type = CONTENTTYPE_APPLICATION_STREAM;
            }
        }
		if(CONTENTTYPE_APPLICATION_STREAM.equals(type)){
			type = CONTENTTYPE_APPLICATION_STREAM + ";charset=" + Charset.GBK.getCode();
		}
		resp.setHeader("Content-Disposition", "attachment;filename="
				+ new String(fileObj.getWjm().getBytes(Charset.GBK.getCode()), StandardCharsets.ISO_8859_1));
		resp.setHeader("filename", URLEncoder.encode(fileObj.getWjm(), StandardCharsets.UTF_8.name()));
        resp.setContentType(type);
    }
	/**
	 * 将字符串以文件形式下载
     * @param resp 响应信息
	 * @param data 字符串
     * @param fileObj 文件对象
	 */
	public static void sendFile(HttpServletResponse resp, String data, SysSjglFile fileObj) {
		sendBytes(resp, data.getBytes(), fileObj);
	}

	/**
	 * 从磁盘上下载所需的文件信息
     * @param resp 响应信息
	 * @param file 文件的信息
	 * @param fileObj 文件对象
	 */
	public static void sendFile(HttpServletResponse resp,File file, SysSjglFile fileObj) {
		FileInputStream fin = null;
		try {
			fin = new FileInputStream(file);
			sendBytes(resp, Utils.readByteArray(new FileInputStream(file)), fileObj);
		} catch (Exception e) {
			slog.debug("像前端发送数据失败:"+e.getMessage());
		} finally {
			// 关闭输入流
			if (fin != null) {
				try {
					fin.close();
				} catch (Exception e) {
					slog.debug("像前端发送数据失败:"+e.getMessage());
				}
			}
		}
	}

	/**
	* @Description: 获取HTTP请求的string类型参数值
	* @param  request
	* @param  name     参数名
	* @param  dval     默认赋值
	* @return String
	* @throws
	 */
	public static String getString(HttpServletRequest request, String name, String dval) {
        return getRequestValue(request, name);
	}

	public static boolean getBoolean(HttpServletRequest request, String name, boolean dval) {
        return TypeUtils.castToBoolean(getRequestValue(request, name));
	}
	public static int getInt(HttpServletRequest request, String name, int dval) {
        return TypeUtils.castToInt(getRequestValue(request, name));
	}
	public static long getLong(HttpServletRequest request, String name, long dval) {
        return TypeUtils.castToLong(getRequestValue(request, name));
	}
	public static double getDouble(HttpServletRequest request, String name, double dval) {
        return TypeUtils.castToDouble(getRequestValue(request, name));
	}
	public static float getFloat(HttpServletRequest request, String name, float dval) {
		return TypeUtils.castToFloat(getRequestValue(request, name));
	}
	private static String getRequestValue(HttpServletRequest request, String name) {
		String value = null;
		try {
			value = request.getParameter(name);
		} catch (Exception e) {
			value = null;
		}
		return (value);
	}

	public static String getBasePath(HttpServletRequest request) {
		String path = request.getContextPath();
		String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path
				+ "/";
		return basePath;
	}

	/**
	 * 获取IP
	 *
	 * @param request
	 * @return
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("X-Real-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		if(ip.contains(",")){
			//有些代理场景会是逗号分割的多个ip
			ip = ip.split(",")[0];
		}
		return ip;
	}
	/**
	 * 获取真实IP
	 * @param request
	 * @return
	 */
	public static String getRealIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("X-Real-IP");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	/**
	 * 去除null
	 *
	 * @param args
	 *            多个参数 例如： String s1,String s2........等
	 * @return
	 * @date 2014-4-26
	 */
	public static Object[] removeNUll(Object... args) {
		for (int i = 0, j = args.length; i < j; i++) {
			if (args[i] == null) {
				args[i] = "";
			}
		}
		return args;
	}

	public static Double getTimeToDouble(Date t) {
		if (t == null)
			return null;
		DateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
		return Double.parseDouble(format.format(t));
	}
}
