/**
* Project Name:myutils
* Date:2017年7月8日
* Copyright (c) 2017, jingma All Rights Reserved.
*/

package cn.benma666.myutils;

import cn.benma666.iframe.DictManager;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;

import java.util.Map;
import java.util.Map.Entry;

/**
 * 模板工具 <br/>
 * date: 2017年7月8日 <br/>
 * @author jingma
 * @version 0.1
 */
public class TmplUtil {

    /**
    * 字符串模板
    */
    public static GroupTemplate gtStr;
    /**
    * 字符串模板SQL
    */
    public static GroupTemplate gtStrSql;

    /**
    * 文件模板
    */
    public static GroupTemplate gtFile;

    static{
        try {
            ResourceLoader<?> resourceLoader = new StringTemplateResourceLoader();
            Configuration cfg = Configuration.defaultConfiguration();
            gtStr = new GroupTemplate(resourceLoader, cfg);

            resourceLoader = new ClasspathResourceLoader();
            gtFile = new GroupTemplate(resourceLoader, cfg);

            resourceLoader = new StringTemplateResourceLoader();
            cfg = Configuration.defaultConfiguration();
            cfg.setStatementStart("/*");
            cfg.setStatementEnd("*/");
            gtStrSql = new GroupTemplate(resourceLoader, cfg);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
    * 获取指定模板文件的模板对象 <br/>
    * @author jingma
    * @param tmplPath 模板文件路径
    * @return 模板对象
     */
    public static Template getTmplByFile(String tmplPath) {
        return gtFile.getTemplate(tmplPath);
    }

    /**
    * 获取指定模板字符串的模板对象 <br/>
    * @author jingma
    * @param tmplStr 模板字符串
    * @return 模板对象
     */
    public static Template getTmplByStr(String tmplStr) {
        return gtStr.getTemplate(tmplStr);
    }

    /**
    * 模板绑定数据 <br/>
    * @author jingma
    * @param tmplPath 模板文件路径
    * @param params 数据
    * @return 渲染后的字符串
    */
    public static String buildByFile(String tmplPath, Map<String, Object> params) {
        return build(tmplPath, params, gtFile);
    }

    /**
    * 模板绑定数据 <br/>
    * @author jingma
    * @param tmplStr 模板
    * @param params 数据
    * @return 渲染后的字符串
    */
    public static String buildStr(String tmplStr, Map<String, Object> params) {
        if(tmplStr.startsWith("[ybmb]:")){
            //一些负责的模板走大字典
            tmplStr = DictManager.zdMcByDm("SYS_COMMON_YBMB",tmplStr.substring("[ybmb]:".length()));
        }
        return build(tmplStr, params, gtStr);
    }
    /**
    * 模板绑定数据SQL <br/>
    * @author jingma
    * @param tmplStr 模板
    * @param params 数据
    * @return 渲染后的字符串
    */
    public static String buildStrSql(String tmplStr, Map<String, Object> params) {
        if(tmplStr.startsWith("[ybmb]:")){
            //一些负责的模板走大字典
            tmplStr = DictManager.zdMcByDm("SYS_COMMON_YBMB",tmplStr.substring("[ybmb]:".length()));
        }
        return build(tmplStr, params, gtStrSql);
    }

    /**
     * @param tmpl 模板，文件模板时为目标路径
     * @param params 参数对象
     * @param gt 模板对象
     * @return 渲染结果
     */
    public static String build(String tmpl, Map<String, Object> params, GroupTemplate gt) {
        if (StringUtil.isEmpty(tmpl)) {
            return tmpl;
        }
        Template t = gt.getTemplate(tmpl);
        for(Entry<String, Object> entry : params.entrySet()){
            t.binding(entry.getKey(),entry.getValue());
        }
        return t.render().trim();
    }
}
