package cn.benma666.myutils;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSONObject;
import org.markdown4j.Markdown4jProcessor;

/**
 * markdown工具
 */
public class MdUtil extends BasicObject {
    /**
     * @param mdStr markdown字符串
     * @return 解析出的json对象
     */
    public static JSONObject parseJson(String mdStr){
        try {
            //解析markdown为html再转为json对象
            return XmlUtil.xmlToJsonObject(new Markdown4jProcessor().process(mdStr));
        }catch (Exception e){
            throw new MyException("markdown文件解析json出错："+mdStr,e);
        }
    }
}
