package cn.benma666.myutils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * * 数学工具
 */
public class MathUtil {
    /**
     * 四舍五入
     * @param val 待处理的数字
     * @param scale 保留小数位数
     * @return 结果
     */
    public static Double round(double val, int scale){
        double n = Math.pow(10, scale);
        return Math.round(val*(int)n)/n;
    }
    /**
     * 使用 BigDecimal 进行加法运算。
     *
     * @param num1 第一个加数
     * @param num2 第二个加数
     * @return 加法运算的结果
     */
    public static Double add(double num1, double num2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(num1));
        BigDecimal bd2 = new BigDecimal(Double.toString(num2));
        return bd1.add(bd2).setScale(6, RoundingMode.HALF_UP).doubleValue();
    }

    /**
     * 使用 BigDecimal 进行减法运算。
     *
     * @param num1 被减数
     * @param num2 减数
     * @return 减法运算的结果
     */
    public static Double subtract(double num1, double num2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(num1));
        BigDecimal bd2 = new BigDecimal(Double.toString(num2));
        return bd1.subtract(bd2).setScale(6, RoundingMode.HALF_UP).doubleValue();
    }

    /**
     * 使用 BigDecimal 进行乘法运算。
     *
     * @param num1 乘数
     * @param num2 乘数
     * @return 乘法运算的结果
     */
    public static Double multiply(double num1, double num2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(num1));
        BigDecimal bd2 = new BigDecimal(Double.toString(num2));
        return bd1.multiply(bd2).setScale(6, RoundingMode.HALF_UP).doubleValue();
    }

    /**
     * 使用 BigDecimal 进行除法运算。
     *
     * @param num1 被除数
     * @param num2 除数
     * @return 除法运算的结果
     */
    public static Double divide(double num1, double num2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(num1));
        BigDecimal bd2 = new BigDecimal(Double.toString(num2));
        return bd1.divide(bd2, 6, RoundingMode.HALF_UP).doubleValue(); // 注意除法可能需要处理除数为零的情况
    }

}
