/**
* Project Name:myutils
* Date:2017年7月8日
* Copyright (c) 2017, jingma All Rights Reserved.
*/

package cn.benma666.myutils;

import com.alibaba.fastjson.JSONObject;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;

/**
 * JVM工具类 <br/>
 * date: 2017年7月8日 <br/>
 * @author jingma
 * @version
 */
public class JVMUtil {

    /**
    * 获取java进程列表 <br/>
    * @author jingma
    * @return
    */
    public static JSONObject getProcessList(){
        JSONObject result = new JSONObject();
        try {
            // 获取监控主机
            MonitoredHost local = MonitoredHost.getMonitoredHost("localhost");
            // 取得所有在活动的虚拟机集合
            Set<?> vmlist = new HashSet<Object>(local.activeVms());
            // 遍历集合，输出PID和进程名
            for(Object process : vmlist) {
                MonitoredVm vm = local.getMonitoredVm(new VmIdentifier("//" + process));
                // 获取类名
                String processname = MonitoredVmUtil.mainClass(vm, true);
                result.put(process.toString(), processname);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
    * 获取进程id <br/>
    * @author jingma
    * @return
    */
    public static String getProcessId(){
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }

    /**
    * 获取系统名称 <br/>
    * @author jingma
    * @return
    */
    public static String getOsName(){
        return System.getProperty("os.name");
    }

    /**
     * @return 是否Windows
     */
    public static boolean isWindow(){
        return getOsName().contains("Windows");
    }

    /**
     * @return 系统编码
     */
    public static String getSysEncoding(){
        return isWindow()?"GBK":"UTF-8";
    }

    /**
    * 获取JAVA_HOME <br/>
    * @author jingma
    * @return
    */
    public static String getJavaHome(){
        return System.getProperty("java.home");
    }

    /**
    * 获取java版本 <br/>
    * @author jingma
    * @return
    */
    public static String getJavaVersion(){
        return System.getProperty("java.version");
    }
}
