package cn.benma666.myutils;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Locale;
import java.util.Map;

/**
 * 基于okhttp实现
 */
public class HttpByHttpClient extends BasicObject implements HttpInterface{
    private static final HttpInterface hi = new HttpByHttpClient();
    private HttpByHttpClient(){

    }
    public static HttpInterface getInstance() {
        return hi;
    }
    /**
     * 验证证书的客户端
     */
    private static final CloseableHttpClient clientYzzs;
    /**
     * 忽略证书的客户端
     */
    private static final CloseableHttpClient clientHlzs;

    static {
        HttpClientBuilder hcConf = HttpClients.custom();
        clientYzzs = hcConf.build();
        hcConf.setSSLSocketFactory(new SSLConnectionSocketFactory(HttpUtil.trustAllHttpsCertificates(),
                NoopHostnameVerifier.INSTANCE));//忽略验证证书
        clientHlzs = hcConf.build();
    }

    @Override
    public InputStream inputStream(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        CloseableHttpClient client;
        try {
            if(url.startsWith("https")&&(isBlank(rp.getString("my-hlzs")) || TypeUtils.castToBoolean(rp.getString("my-hlzs")))){
                client = clientHlzs;
            }else {
                client = clientYzzs;
            }
            //请求内容形式
            String ct = "application/x-www-form-urlencoded;charset=" + qqbm;
            if(rp.containsKey(HttpUtil.CONTENT_TYPE)){
                ct = rp.getString(HttpUtil.CONTENT_TYPE);
            }
            if(ct.contains(ContentType.MULTIPART_FORM_DATA.getMimeType())){
                throw new MyException("该工具类暂未支持文件上传，请采用okhttp实现");
            }
            HttpRequestBase http;
            String method = rp.getString(HttpUtil.REQUEST_METHOD);
            if(StringUtil.isBlank(method)||HttpPost.METHOD_NAME.equals(method)){
                http = new HttpPost(url);
                if(!isBlank(param)){
                    ((HttpPost)http).setEntity(new StringEntity(param.toString(), qqbm));
                }
            }else{
                //拼接参数
                if(!isBlank(param)){
                    url = url+(url.contains("?")?"&":"?")+param;
                }
                http = new HttpGet(url);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(cssc)
                    .setSocketTimeout(cssc).setConnectionRequestTimeout(cssc).build();
            http.setConfig(requestConfig);
            // 设置通用的请求属性
            http.setHeader("Accept", "*/*");
            http.setHeader("Connection", "Keep-Alive");
            http.setHeader("User-Agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            http.setHeader("Accept-Charset", qqbm);
            http.setHeader(HttpUtil.CONTENT_TYPE, ct);
            http.setHeader("Accept-Language", Locale.getDefault().toString());
            for(Map.Entry<String, Object> e:rp.entrySet()){
                http.setHeader(e.getKey(), e.getValue().toString());
            }
            if(http.getLastHeader(HttpUtil.CONTENT_TYPE).getValue().contains(ContentType.MULTIPART_FORM_DATA.getMimeType())){
                throw new MyException("该工具类暂未支持文件上传，请采用okhttp实现");
            }
            log.trace("请求属性{}", rp);
            HttpResponse response = client.execute(http);
            HttpEntity resEntity = response.getEntity();

            //获返回取头部信息
            for(Header hd:response.getAllHeaders()){
                repHeards.put(hd.getName(),hd.getValue());
            }
            log.trace("返回头信息{}",repHeards.toString());
            int code = response.getStatusLine().getStatusCode();
            if(code == HttpURLConnection.HTTP_MOVED_TEMP
                    ||code == HttpURLConnection.HTTP_MOVED_PERM){
                //重定向
                return inputStream(response.getFirstHeader("Location").getValue(),
                        param,qqbm,cssc,rp,repHeards);
            }
            //得到输入流
            return resEntity.getContent();
        } catch (Exception e) {
            throw new MyException("请求失败", e, url+"->"+param+rp);
        }
    }
}
