package cn.benma666.myutils;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import org.apache.http.entity.ContentType;

import javax.net.ssl.HttpsURLConnection;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * 基于okhttp实现
 */
public class HttpByHUC extends BasicObject implements HttpInterface{
    private static final HttpInterface hi = new HttpByHUC();

    public static HttpInterface getInstance() {
        return hi;
    }
    private HttpByHUC(){

    }
    @Override
    public InputStream inputStream(String url, Object param, String qqbm, int cssc, JSONObject rp, JSONObject repHeards) {
        DataOutputStream out = null;
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            if(url.startsWith("https")&&(isBlank(rp.getString("my-hlzs")) || TypeUtils.castToBoolean(rp.getString("my-hlzs")))){
                //添加https场景忽略证书
                HttpsURLConnection.setDefaultSSLSocketFactory(HttpUtil.trustAllHttpsCertificates().getSocketFactory());
                HttpsURLConnection conns = (HttpsURLConnection) conn;
                conns.setHostnameVerifier((hostname, session) -> true);
            }
            // 设置通用的请求属性
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Accept-Charset", qqbm);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset="+qqbm);
            conn.setRequestProperty("Accept-Language", Locale.getDefault().toString());
            if(StringUtil.isBlank(rp.getString("RequestMethod"))){
                conn.setRequestMethod("POST");
            }else{
                conn.setRequestMethod(rp.getString("RequestMethod"));
            }
            for(Map.Entry<String, Object> e:rp.entrySet()){
                conn.setRequestProperty(e.getKey(), e.getValue().toString());
            }
            if(conn.getRequestProperty(HttpUtil.CONTENT_TYPE).contains(ContentType.MULTIPART_FORM_DATA.getMimeType())){
                throw new MyException("该工具类暂未支持文件上传，请采用okhttp实现");
            }
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(cssc);
            conn.setReadTimeout(cssc);
            log.trace("请求属性{}", JSON.toJSON(conn.getRequestProperties()));
            // 获取URLConnection对象对应的输出流
            if(StringUtil.isNotBlank(param)){
                conn.setRequestProperty("Content-Length", java.lang.String.valueOf((param.toString().getBytes(qqbm)).length));
                out = new DataOutputStream(conn.getOutputStream());
                // 发送请求参数
                out.write(param.toString().getBytes(qqbm));
                // flush输出流的缓冲
                out.flush();
            }
            //获返回取头部信息
            for(Map.Entry<String, List<String>> hf:conn.getHeaderFields().entrySet()){
                repHeards.put(hf.getKey(), conn.getHeaderField(hf.getKey()));
            }
            log.trace("返回头信息{}",repHeards.toString());
            if(conn.getResponseCode()==HttpURLConnection.HTTP_MOVED_TEMP
                    ||conn.getResponseCode()==HttpURLConnection.HTTP_MOVED_PERM){
                //重定向
                return inputStream(conn.getHeaderField("Location"),param,qqbm,cssc,rp,repHeards);
            }
            //得到输入流
            return HttpURLConnection.HTTP_OK == conn.getResponseCode()?
                    conn.getInputStream():conn.getErrorStream();
        } catch (Exception e) {
            throw new MyException("请求失败", e, url+"->"+param+rp);
        } finally{
            //使用finally块来关闭输出流、输入流
            FileUtil.closeStream(out);
        }
    }
}
