package cn.benma666.myutils;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.util.TypeUtils;
import org.beetl.core.fun.GeneralGetMethodInvoker;
import org.beetl.core.fun.MethodInvoker;
import org.beetl.core.fun.ObjectUtil;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * 类相关工具
 */
public class ClassUtil extends BasicObject {
    /**
     * 批量方法执行
     * @param obj 对象
     * @param param 参数，paramTypes类型列表，paramList值列表
     */
    public static void plMethodInvoke(Object obj,JSONObject param){
        if(isBlank(param)||obj==null){
            return;
        }
        try {
            for(Method m : obj.getClass().getMethods()){
                if(param.containsKey(m.getName())){
                    m.invoke(obj,param.getJSONArray(m.getName()).toArray());
                }
            }
        } catch (Exception e1) {
            slog.warn("方法执行失败",e1);
        }
    }

    /**
     * 设置值
     * @param key 键
     * @param value 值
     * @param th 对象
     * @return 是否成功
     */
    public static boolean setVal(String key, Object value,Object th) {
        return setVal(key,value,th,null);
    }
    /**
     * 设置值
     * @param key 键
     * @param value 值
     * @param th 对象
     * @param map map
     * @return 是否成功
     */
    public static boolean setVal(String key, Object value,Object th,Map<String,Object> map) {
        if(value==null){
            return true;
        }
        if(StringUtil.isBlank(key)){
            throw new MyException("类属性设置key不能为空："+ value);
        }
        if(key.startsWith("$.")){
            return JSONPath.set(th, key, value);
        }
        Object val = value;
        //先尝试读取对象属性
        Method m;
        try {
            try {
                try {
                    m = th.getClass().getMethod("get" + StringUtil.upperCaseFast(key));
                }catch (NoSuchMethodException e){
                    m = th.getClass().getMethod("is" + StringUtil.upperCaseFast(key));
                }
                Class<?> cls = m.getReturnType();
                if(!cls.isInstance(val)){
                    val = TypeUtils.castToJavaBean(value,cls);
                }
                m = th.getClass().getMethod("set" + StringUtil.upperCaseFast(key),cls);
                m.invoke(th, val);
                return true;
            }catch (NoSuchMethodException e){
                try {
                    m = th.getClass().getMethod("set",String.class,Object.class);
                }catch (NoSuchMethodException e1){
                    m = th.getClass().getMethod("put",String.class,Object.class);
                }
                m.invoke(th, key, val);
                return true;
            }
        } catch (Exception e) {
            if(th instanceof Map && map==null){
                map = (Map<String, Object>) th;
            }
            if(map!=null){
                map.put(key,value);
                return true;
            }else {
                throw new MyException("bean设置异常:"+key+","+val,e);
            }
        }
    }

    /**
     * 通过反射获取值
     * @param key 字段名称
     * @param val 优先值，该值不为null则直接返回
     * @param th 对象
     * @return 值
     */
    public static Object getVal(String key, Object val, Object th) {
        if(val != null){
            return val;
        }
        if(StringUtil.isBlank(key)){
            throw new MyException("类属性获取key不能为空："+ th);
        }
        if(key.startsWith("$.")){
            return JSONPath.eval(th, key);
        }
        Method m;
        try {
            //尝试读取对象属性
            try {
                m = th.getClass().getMethod("get" + StringUtil.upperCaseFast(key));
            } catch (NoSuchMethodException e) {
                m = th.getClass().getMethod("is" + StringUtil.upperCaseFast(key));
            }
            return m.invoke(th);
        } catch (NoSuchMethodException e) {
            try {
                try {
                    m = th.getClass().getMethod("get", String.class);
                } catch (NoSuchMethodException e1) {
                    m = th.getClass().getMethod("get", Object.class);
                }
                return m.invoke(th, key);
            } catch (Exception e2) {
                throw new MyException("属性读取失败：" + key,e2);
            }
        } catch (Exception e) {
            throw new MyException("属性读取失败：" + key,e);
        }
    }

    /**
     * 判断对象是否存在属性
     * @param o 对象，可以是map或者一般对象
     * @param key 属性名称
     * @return 是否存在
     */
    public static boolean hasAttribute(Object o,String key){
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Map) {
            return ((Map<?, ?>) o).containsKey(key);
        }
        Class type = o.getClass();
        //TODO3.0,  通过反射获取
        MethodInvoker invoke = ObjectUtil.getInvokder(type, key);
        return invoke != null && !(invoke instanceof GeneralGetMethodInvoker);
    }
}
