/**
 * Project Name:myutils
 * Date:2017年5月28日
 * Copyright (c) 2017, jingma All Rights Reserved.
 */

package cn.benma666.main;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.Conf;
import cn.benma666.iframe.MyParams;
import cn.benma666.myutils.StringUtil;
import cn.benma666.myutils.TmplUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;
import org.beetl.core.Template;
import org.beetl.sql.core.SqlId;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;

/**
 * 生成POJO对象代码 <br/>
 * date: 2017年5月28日 <br/>
 *
 * @author jingma
 * @version 0.1
 */
public class GenPojoCode extends BasicObject {
    public static void main(String[] args) {
        if (args.length != 1) {
            slog.error("请输入参数文件路径");
            return;
        }
        try {
            //加载配置
            MyParams myParams = MyParams.parseObject(Utils.read(new FileInputStream(args[0])));
            Conf.defaultInit();
            SysSjglSjzt sjzt = SysSjglSjzt.builder().ljc(myParams.getString("url")).yhm(myParams.getString("user"))
                    .mm(myParams.getString("pwd")).lx(myParams.getString("lx")).kzxxObj(new JSONObject()).build();
            //创建数据源
            Db db = Db.use(UtilConst.DEFAULT,sjzt);
            for (String tableName : myParams.getJSONArray("tableNames").toJavaList(String.class)) {
                //加载模板
                Template t = TmplUtil.getTmplByFile("/other/pojo.btl");
                //设置表名
                myParams.put("tableName", tableName);
                //查询表信息
                JSONObject tableInfo = db.findFirst(SqlId.of("pojo", "tab_comments"), myParams);
                if(tableInfo==null){
                    slog.error("{}找不到",tableName);
                    continue;
                }
                myParams.put("tableInfo", tableInfo);
                //查询字段信息
                List<JSONObject> colList = db.find(SqlId.of("pojo", "cols_info"), myParams);
                myParams.put("colList", colList);
                t.binding(myParams);
                slog.info("模板变量："+myParams);
                String filepath = valByDef(myParams.getString("javasrc"), "src/main/java")
                        + UtilConst.FXG + myParams.getString("pkg").replace(".", UtilConst.FXG) + UtilConst.FXG
                        + StringUtil.upperCaseFast(StringUtil.underlineTohump(tableName)) + ".java";
                File file = new File(filepath);
                if(!file.getParentFile().exists()){
                    //目录不存在则创建
                    file.getParentFile().mkdirs();
                }
                t.renderTo(new FileOutputStream(filepath));
                slog.info("成功生成实体：{}",filepath);
            }
        } catch (Exception e) {
            slog.error("创建pojo异常",e);
        }

    }
}
