/**
 * Project Name:myutils
 * Date:2018年12月13日
 * Copyright (c) 2018, jingma All Rights Reserved.
 */

package cn.benma666.iframe;

import cn.benma666.constants.UtilConst;
import cn.benma666.dict.Cllx;
import cn.benma666.exception.VerifyRuleException;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.SfzhUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.myutils.TmplUtil;
import com.alibaba.druid.DbType;
import com.alibaba.fastjson.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.Date;

/**
 * 转换规则 <br/>
 * date: 2018年12月13日 <br/>
 * @author jingma
 * @version 0.1
 */
public class TransRule extends BasicObject{

    public static final String VALUE = "value";

    /**
     * 转换规则
     * @param val 值
     * @param rule 规则
     * @return 转换值
     */
    public static Object ruleTrans(Object val, JSONObject rule) {
        JSONObject rootRule = new JSONObject();
        rootRule.put(UtilConst.DEFAULT,rule);
        return ruleTrans(val,new MyParams(),rootRule,UtilConst.DEFAULT);
    }
    /**
     * 规则校验 <br/>
     * @author jingma
     * @param val      值
     * @param myParams 相关参数
     * @param rootRule     转换规则
     * @param cllx     处理类型
     * @return 转换结果
     */
    public static Object ruleTrans(Object val, MyParams myParams, JSONObject rootRule,String cllx) {
        JSONObject zhgz = rootRule.getJSONObject(cllx);
        if(zhgz==null){
            return val;
        }
        Object value = val;
        MyParams zdParams = new MyParams();
        //转为大写、转为小写、去掉前后空格，字符串替换，身份证转换，时间格式转换
        for (String rule : zhgz.keySet()) {
            JSONObject gzObj = zhgz.getJSONObject(rule);
            switch (rule) {
                case "null":
                    if(value == null){
                        break;
                    }
                    value = "";
                    break;
                case "sfzh":
                    if(value == null){
                        break;
                    }
                    String v = SfzhUtil.conver15CardTo18(value.toString());
                    if (v != null) {
                        value = v;
                    }
                    break;
                case "date":
                    if(value == null){
                        break;
                    }
                    Date d = DateUtil.parseDate(value,valByDef(gzObj
                            .getBoolean("lenient"),true));
                    if (d != null) {
                        String f = DateUtil.DATE_FORMATTER14;
                        if (StringUtil.isNotBlank(gzObj.getString(VALUE))) {
                            f = gzObj.getString(VALUE);
                        }
                        value = DateUtil.doFormatDate1(d, f);
                    }
                    break;
                case "zwdx":
                    //转为大写
                    if(value == null){
                        break;
                    }
                    value = value.toString().toUpperCase();
                    break;
                case "zwxx":
                    //转为小写
                    if(value == null){
                        break;
                    }
                    value = value.toString().toLowerCase();
                    break;
                case "qdqhkg":
                    if(value == null){
                        break;
                    }
                    //去掉前后空格
                    if(value instanceof String){
                        value = value.toString().trim();
                    }
                    break;
                case "zfth":
                    if(value == null){
                        break;
                    }
                    //字符替换
                    value = value.toString().replaceAll(gzObj.getString("yzfc"), gzObj.getString("xzfc"));
                    break;
                case "zdzh":
                    //字典转换
                    if(value == null){
                        break;
                    }
                    zdParams.set("$.yobj.zdlb",gzObj.getString(VALUE));
                    zdParams.set("$.yobj.dm",value);
                    value = DictManager.zdObjNoCache(zdParams).getString("mc");
                    break;
                case "tmpl":
                    //设置值,基于beetl模板
                    myParams.set("$.sys.value", value);
                    myParams.set("$.sys.gzObj", gzObj);
                    value = TmplUtil.buildStr(gzObj.getString(VALUE),myParams);
                    break;
                case "clob":
                    //数据库中为大字段，转为流，mysql不需要，oracle需要
                    if(!isBlank(value) && !Cllx.select.name().equals(cllx)
                            && DbType.oracle.name().equals(myParams.getString("$.sjdx.dxztlx"))){
                        return new StringReader(value.toString());
                    }
                    break;
                case "blob":
                    //数据库中为二进制，转为流
                    if(!isBlank(value) && !Cllx.select.name().equals(cllx)
                            && DbType.oracle.name().equals(myParams.getString("$.sjdx.dxztlx"))){
                        return new ByteArrayInputStream(value.toString().getBytes());
                    }
                    break;
                default:
                    throw new VerifyRuleException("不支持转换规则:" + rule);
            }
        }
        return value;
    }
}
