package cn.benma666.iframe;

import cn.benma666.domain.SysQxYhxx;
import cn.benma666.domain.SysSjglSjdx;
import cn.benma666.domain.SysSjglSjzd;
import cn.benma666.exception.BusinessException;
import cn.benma666.json.MyJSONObject;
import cn.benma666.params.Other;
import cn.benma666.params.Sql;
import cn.benma666.params.Sys;
import cn.benma666.params.Znjh;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 我的参数对象
 */
@Setter
@Getter
@Slf4j
public class MyParams extends MyJSONObject {

    public MyParams(){
    }

    public MyParams(Map<String, Object> map) {
        super(map);
    }

    public MyParams(boolean ordered) {
        super(ordered);
    }

    public MyParams(int initialCapacity) {
        super(initialCapacity);
    }

    public MyParams(int initialCapacity, boolean ordered) {
        super(initialCapacity, ordered);
    }

    public static MyParams parseObject(String text) {
        return parseObject(text,Feature.OrderedField);
    }
    /**
     * 解析字符串为JSON对象
     */
    public static MyParams parseObject(String text, Feature... features) {
        JSONObject obj;
        try{
            obj = JSONObject.parseObject(text, features);
            if(obj==null){
                return new MyParams();
            }else {
                return new MyParams(obj.getInnerMap());
            }
        }catch (Throwable e){
            throw new BusinessException("解析json参数失败，请检查参数格式："+text,e);
        }
    }

    /**
     * 获取yobj参数的对象
     */
    public JSONObject yobj(){
        return yobj(JSONObject.class);
    }
    /**
     * 获取yobj参数的对象
     */
    public JSONObject obj(){
        return obj(JSONObject.class);
    }
    /**
     * 处理类型扩展
     */
    public JSONObject cllxkz(){
        return object("cllxkz",JSONObject.class);
    }
    /**
     * 获取yobj参数的对象
     */
    public <T> T yobj(Class<T> t){
        return object(KEY_YOBJ,t);
    }
    /**
     * 获取yobj参数的对象
     */
    public <T> T obj(Class<T> t){
        return object(KEY_OBJ,t);
    }
    /**
     * 获取用户对象
     */
    public SysQxYhxx user(){
        return getObject(KEY_USER,SysQxYhxx.class);
    }
    /**
     * @return 分页参数的对象
     */
    public PageInfo page(){
        return object(KEY_PAGE, PageInfo.class);
    }
    /**
     * 数据对象
     */
    public SysSjglSjdx sjdx(){
        return object(KEY_SJDX, SysSjglSjdx.class);
    }
    /**
     * 智能交换参数
     */
    public Znjh znjh(){
        return object(KEY_ZNJH, Znjh.class);
    }
    /**
     * sql查询相关参数
     */
    public Sql sql(){
        return object(KEY_SQL, Sql.class);
    }
    /**
     * 系统参数
     */
    public Sys sys(){
       return object(KEY_SYS, Sys.class);
    }
    /**
     * 系统参数
     */
    public Other other(){
        return object(KEY_OTHEROBJ, Other.class);
    }
    /**
     * 全部字段信息
     */
    public Map<String, SysSjglSjzd> fields(){
        Map map = object(KEY_FIELDS, Map.class);
        map.forEach((k,v)->{
            if(v instanceof JSONObject){
                //把json对象转为字段实体
                map.put(k,((JSONObject) v).toJavaObject(SysSjglSjzd.class));
            }
        });
        return map;
    }

    /**
     * 获取对象实体，获取的实体会设置回参数对象，便于实体修改在参数对象中生效。
     * @param key 键
     * @param t 对象类
     * @param <O> 泛型
     * @return 实体对象
     */
    public <O> O object(String key, Class<O> t){
        O entity = super.getObject(key, t);
        if(entity==null){
            try {
                entity = t.getConstructor().newInstance();
            }catch (Throwable t1){
                log.debug("{}无参构造失败",t,t1);
            }
        }
        //将配置对象设置回参数对象，外部可以对该对象进行修改，修改对参数对象生效。
        this.set(key,entity);
        return entity;
    }
}
