package cn.benma666.iframe;

import cn.hutool.log.LogFactory;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 回调接口
 */
public interface HdInterface {
    /**
     * 回调方法
     * @param list 数据
     * @param hdjs 回调结束
     * @return 处理结果
     */
    Result run(List<JSONObject> list,boolean hdjs);
    /**
     * 回调方法
     * @param list 数据，该值为null时，表示远程异常
     * @param hdjs 回调结束
     * @param result 结果对象
     * @return 处理结果
     */
    default Result run(List<JSONObject> list,boolean hdjs,Result result){
        if(!result.isStatus()){
            LogFactory.get().warn("回调方异常："+result.getMsg());
        }
        return run(list,hdjs);
    }
}
